/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.login.LoginStore;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SneakyAutoLoginUtil {
    private static final Logger log = LoggerFactory.getLogger(SneakyAutoLoginUtil.class);

    @Nullable
    public static ApplicationUser logUserInByName(String username, HttpServletRequest request) {
        ApplicationUser loggedInUser = SneakyAutoLoginUtil.logUserIn(username, request);
        if (loggedInUser == null) {
            return null;
        }
        try {
            LoginStore loginStore = (LoginStore)ComponentAccessor.getComponent(LoginStore.class);
            Long loginCount = loginStore.getLoginInfo(loggedInUser).getLoginCount();
            if (loginCount == null || loginCount == 0L) {
                loginStore.recordLoginAttempt(loggedInUser, true);
            }
        }
        catch (Exception e) {
            log.error("Could not record the login attempt for user '" + username + "'.", (Throwable)e);
        }
        return loggedInUser;
    }

    @Nullable
    public static ApplicationUser logUserIn(String username, HttpServletRequest request) {
        if (StringUtils.isBlank((String)username)) {
            log.warn("Unable to automatically log in: user is null or blank");
        } else {
            UserManager userManager = ComponentAccessor.getUserManager();
            ApplicationUser user = userManager.getUserByName(username);
            try {
                CrowdService crowdService = ComponentAccessor.getCrowdService();
                if (crowdService != null) {
                    request.getSession().setAttribute("seraph_defaultauthenticator_user", (Object)user);
                    request.getSession().setAttribute("seraph_defaultauthenticator_user_id", (Object)username);
                    request.getSession().setAttribute("seraph_defaultauthenticator_logged_out_user", null);
                    InternalWebSudoManager webSudoManager = (InternalWebSudoManager)ComponentAccessor.getComponent(InternalWebSudoManager.class);
                    webSudoManager.markWebSudoRequest(request);
                    return user;
                }
                log.warn("Unable to automatically log in: crowdService is null");
            }
            catch (Exception e) {
                log.warn("Error with automatic log in. The user will need to log in manually.", (Throwable)e);
            }
        }
        return null;
    }
}

