/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Predicate;
import org.apache.commons.lang3.StringUtils;

public final class AccessDisablingHelperConfig {
    private final String featureFlag;
    private final String blockAccessSince;
    private final String logDeprecatedSince;
    private final boolean blockAnonymous;
    private final GlobalPermissionKey permissionKey;
    private final Predicate<ApplicationUser> additionalCondition;

    public static EndpointDisablingConfigBuilder builder() {
        return new EndpointDisablingConfigBuilder();
    }

    private AccessDisablingHelperConfig(String featureFlag, String blockAccessSince, String logDeprecatedSince, boolean blockAnonymous, GlobalPermissionKey permissionKey, Predicate<ApplicationUser> additionalCondition) {
        this.featureFlag = featureFlag;
        this.blockAccessSince = blockAccessSince;
        this.logDeprecatedSince = logDeprecatedSince;
        this.blockAnonymous = blockAnonymous;
        this.permissionKey = permissionKey;
        this.additionalCondition = additionalCondition;
    }

    public String getFeatureFlag() {
        return this.featureFlag;
    }

    public String getBlockAccessSince() {
        return this.blockAccessSince;
    }

    public String getLogDeprecatedSince() {
        return this.logDeprecatedSince;
    }

    public boolean isBlockAnonymous() {
        return this.blockAnonymous;
    }

    public GlobalPermissionKey getPermissionKey() {
        return this.permissionKey;
    }

    public Predicate<ApplicationUser> getAdditionalCondition() {
        return this.additionalCondition;
    }

    public static class EndpointDisablingConfigBuilder {
        private String featureFlag;
        private String blockAccessSince;
        private String logDeprecatedSince;
        private boolean blockAnonymous;
        private GlobalPermissionKey permissionKey;
        private Predicate<ApplicationUser> additionalCondition;

        private EndpointDisablingConfigBuilder() {
        }

        public EndpointDisablingConfigBuilder featureFlag(String featureFlag) {
            this.featureFlag = featureFlag;
            return this;
        }

        public EndpointDisablingConfigBuilder blockAccessSinceVersion(String blockAccessSince) {
            this.blockAccessSince = blockAccessSince;
            return this;
        }

        public EndpointDisablingConfigBuilder logDeprecatedSinceVersion(String logDeprecatedSince) {
            this.logDeprecatedSince = logDeprecatedSince;
            return this;
        }

        public EndpointDisablingConfigBuilder blockAnonymous(boolean blockAnonymous) {
            this.blockAnonymous = blockAnonymous;
            return this;
        }

        public EndpointDisablingConfigBuilder blockForAnyoneWithoutPermission(GlobalPermissionKey permissionKey) {
            this.permissionKey = permissionKey;
            return this;
        }

        public EndpointDisablingConfigBuilder blockAnyoneNotFulfillingCondition(Predicate<ApplicationUser> condition) {
            this.additionalCondition = condition;
            return this;
        }

        public AccessDisablingHelperConfig build() {
            this.validateConfig();
            return new AccessDisablingHelperConfig(this.featureFlag, this.blockAccessSince, this.logDeprecatedSince, this.blockAnonymous, this.permissionKey, this.additionalCondition);
        }

        private void validateConfig() {
            if (StringUtils.isBlank((CharSequence)this.featureFlag)) {
                throw new IllegalStateException("Feature flag name cannot be blank or null");
            }
            if (!this.blockAnonymous && this.permissionKey == null && this.additionalCondition == null) {
                throw new IllegalStateException("You need to provide config with permission key to enforce, enable blocking of anonymous users, or provide a condition the user has to pass.");
            }
        }
    }
}

