/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64;

public class Base64InputStreamConsumer
implements Consumer<InputStream> {
    private String encoded;
    private boolean chunked;

    public Base64InputStreamConsumer(boolean chunked) {
        this.chunked = chunked;
        this.encoded = "";
    }

    public void consume(@Nonnull InputStream element) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtil.copy(element, (OutputStream)baos);
            this.encoded = new String(Base64.encodeBase64((byte[])baos.toByteArray(), (boolean)this.chunked), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getEncoded() {
        return this.encoded;
    }
}

