/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import java.io.File;
import java.io.IOException;

public class Lock {
    File lockFile;
    public static final long LOOP_WAIT_TIME = 1000L;

    public Lock(String fileName) {
        this.lockFile = new File(fileName);
    }

    public Lock(String directoryName, String fileName) {
        this.lockFile = new File(directoryName, fileName);
    }

    public boolean obtain() throws IOException {
        return this.lockFile.createNewFile();
    }

    public boolean obtain(long timeout) throws IOException {
        boolean locked = this.obtain();
        if (locked) {
            return locked;
        }
        long loopTimes = timeout / 1000L;
        long remainder = timeout % 1000L;
        for (long i = 0L; i < loopTimes; ++i) {
            this.sleep(1000L);
            locked = this.obtain();
            if (!locked) continue;
            return locked;
        }
        if (remainder > 0L) {
            this.sleep(remainder);
            locked = this.obtain();
        }
        return locked;
    }

    private void sleep(long loopWaitTime) throws IOException {
        try {
            Thread.sleep(loopWaitTime);
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
    }

    public void release() {
        this.lockFile.delete();
    }

    public boolean isLocked() {
        return this.lockFile.exists();
    }

    public String getLockFilePath() {
        return this.lockFile.getAbsolutePath();
    }
}

