/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.bean.I18nBean;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ParameterStore {
    private ApplicationUser user;
    private List<TextOption> timePeriods;
    private List<Map<String, String>> reporterTypes;
    private List<Map<String, String>> assigneeTypes;
    private List<Map<String, String>> creatorTypes;
    private I18nHelper i18n;

    public ParameterStore(ApplicationUser user) {
        this.user = user;
        this.i18n = new I18nBean(user);
    }

    public ParameterStore(String userName) {
        this(UserUtils.getUser((String)userName));
    }

    public Collection<TextOption> getTimePeriods() {
        if (this.timePeriods == null) {
            this.setTimePeriods();
        }
        return this.timePeriods;
    }

    private void setTimePeriods() {
        this.timePeriods = Lists.newArrayList((Object[])new TextOption[]{new TextOption("-1h", this.i18n.getText("time.periods.hour")), new TextOption("-1d", this.i18n.getText("time.periods.day")), new TextOption("-1w", this.i18n.getText("time.periods.week")), new TextOption("-4w 2d", this.i18n.getText("time.periods.month"))});
    }

    public List<Map<String, String>> getReporterTypes() {
        if (this.reporterTypes == null) {
            this.setReporterTypes();
        }
        return this.reporterTypes;
    }

    private Map<String, String> param(String valueKey, String key, String related) {
        return ImmutableMap.builder().put((Object)"value", (Object)this.i18n.getText(valueKey)).put((Object)"key", (Object)key).put((Object)"related", (Object)related).build();
    }

    private void setReporterTypes() {
        this.reporterTypes = new ArrayList<Map<String, String>>();
        this.reporterTypes.add(this.param("reporter.types.anyuser", "", "select.list.none"));
        this.reporterTypes.add(this.param("reporter.types.noreporter", "issue_no_reporter", "select.list.none"));
        if (this.user != null) {
            this.reporterTypes.add(this.param("reporter.types.currentuser", "issue_current_user", "select.list.none"));
        }
        this.reporterTypes.add(this.param("reporter.types.specifyuser", "specificuser", "select.list.user"));
        this.reporterTypes.add(this.param("reporter.types.specifygroup", "specificgroup", "select.list.group"));
    }

    public List<Map<String, String>> getAssigneeTypes() {
        if (this.assigneeTypes == null) {
            this.setAssigneeTypes();
        }
        return this.assigneeTypes;
    }

    private void setAssigneeTypes() {
        this.assigneeTypes = new ArrayList<Map<String, String>>();
        this.assigneeTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("assignee.types.anyuser")).add((Object)"key", null).add((Object)"related", (Object)"select.list.none").toMap());
        this.assigneeTypes.add(this.param("assignee.types.unassigned", "unassigned", "select.list.none"));
        if (this.user != null) {
            this.assigneeTypes.add(this.param("assignee.types.currentuser", "issue_current_user", "select.list.none"));
        }
        this.assigneeTypes.add(this.param("assignee.types.specifyuser", "specificuser", "select.list.user"));
        this.assigneeTypes.add(this.param("assignee.types.specifygroup", "specificgroup", "select.list.group"));
    }

    public List<Map<String, String>> getCreatorTypes() {
        if (this.creatorTypes == null) {
            this.setCreatorTypes();
        }
        return this.creatorTypes;
    }

    private void setCreatorTypes() {
        this.creatorTypes = new ArrayList<Map<String, String>>();
        this.creatorTypes.add(MapBuilder.newBuilder().add((Object)"value", (Object)this.i18n.getText("creator.types.anyuser")).add((Object)"key", null).add((Object)"related", (Object)"select.list.none").toMap());
        this.creatorTypes.add(this.param("creator.types.nocreator", "issue_anonymous_creator", "select.list.none"));
        if (this.user != null) {
            this.creatorTypes.add(this.param("creator.types.currentuser", "issue_current_user", "select.list.none"));
        }
        this.creatorTypes.add(this.param("creator.types.specifyuser", "specificuser", "select.list.user"));
        this.creatorTypes.add(this.param("creator.types.specifygroup", "specificgroup", "select.list.group"));
    }
}

