/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.collect.EnclosedIterable;
import java.util.concurrent.atomic.AtomicInteger;

public class CountingEnclosedIterable<T>
implements EnclosedIterable<T> {
    private final EnclosedIterable<T> delegate;
    private final AtomicInteger countConsumed = new AtomicInteger(0);

    public CountingEnclosedIterable(EnclosedIterable<T> delegate) {
        this.delegate = delegate;
    }

    public void foreach(Consumer<T> sink) {
        Consumer countingSink = element -> {
            sink.consume(element);
            this.countConsumed.incrementAndGet();
        };
        this.delegate.foreach(countingSink);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int getCountConsumed() {
        return this.countConsumed.get();
    }
}

