/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.index;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.config.properties.BackingPropertySetManager;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.index.IndexingCounter;
import com.atlassian.jira.util.index.IndexingCounterManager;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.Validate;

public class IndexingCounterManagerImpl
implements IndexingCounterManager,
IndexingCounter,
Startable {
    @VisibleForTesting
    static final String COUNTER_LOCK_NAME = IndexingCounterManagerImpl.class.getName() + ".counter";
    @VisibleForTesting
    static final String PROPERTY_KEY = IndexingCounterManagerImpl.class.getName() + ".counterValue";
    private final AtomicBoolean startHasBeenCalled;
    private final BackingPropertySetManager backingPropertySetManager;
    private final ClusterLockService clusterLockService;
    private ClusterLock counterLock;
    private long counter;

    public IndexingCounterManagerImpl(BackingPropertySetManager backingPropertySetManager, ClusterLockService clusterLockService) {
        this.backingPropertySetManager = backingPropertySetManager;
        this.clusterLockService = clusterLockService;
        this.counter = 0L;
        this.startHasBeenCalled = new AtomicBoolean(false);
    }

    public void start() {
        this.counterLock = this.clusterLockService.getLockForName(COUNTER_LOCK_NAME);
        PropertySet propertySet = this.getPropertySet();
        if (propertySet.exists(PROPERTY_KEY)) {
            this.counter = propertySet.getLong(PROPERTY_KEY);
        } else {
            propertySet.setLong(PROPERTY_KEY, this.counter);
        }
        this.startHasBeenCalled.set(true);
    }

    @VisibleForTesting
    PropertySet getPropertySet() {
        return (PropertySet)this.backingPropertySetManager.getPropertySetSupplier().get();
    }

    public long getCurrentValue() {
        this.counterLock.lock();
        try {
            long l = this.counter;
            return l;
        }
        finally {
            this.counterLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long incrementValue() {
        Validate.validState((boolean)this.startHasBeenCalled.get(), (String)"Called incrementValue() before start()", (Object[])new Object[0]);
        this.counterLock.lock();
        try {
            long speculativeIncrement = this.counter + 1L;
            this.getPropertySet().setLong(PROPERTY_KEY, speculativeIncrement);
            long l = ++this.counter;
            return l;
        }
        finally {
            this.counterLock.unlock();
        }
    }
}

