/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.mobile;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.util.mobile.AndroidMobileAppBanner;
import com.atlassian.jira.util.mobile.IosMobileAppBanner;
import com.atlassian.jira.util.mobile.MobileAppBanner;
import com.atlassian.jira.util.mobile.UnknownMobileBanner;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraMobileAppBannerUtils {
    private static final Logger log = LoggerFactory.getLogger(JiraMobileAppBannerUtils.class);
    private static final UserAgentUtil userAgentUtil = new UserAgentUtilImpl();

    @Nonnull
    public static MobileAppBanner getMobileAppBanner(@Nonnull HttpServletRequest request) {
        try {
            String userAgentHeader = request.getHeader("USER-AGENT");
            UserAgentUtil.UserAgent userAgent = userAgentUtil.getUserAgentInfo(userAgentHeader);
            UserAgentUtil.BrowserFamily browserFamily = userAgent.getBrowser().getBrowserFamily();
            UserAgentUtil.OperatingSystem.OperatingSystemFamily operatingSystemFamily = userAgent.getOperatingSystem().getOperatingSystemFamily();
            if (JiraMobileAppBannerUtils.isPluginEnabled()) {
                if (JiraMobileAppBannerUtils.isIOSSafariBrowser(browserFamily, operatingSystemFamily)) {
                    return new IosMobileAppBanner(request);
                }
                if (JiraMobileAppBannerUtils.isAndroidChromeBrowser(browserFamily, operatingSystemFamily)) {
                    return new AndroidMobileAppBanner(request);
                }
            }
        }
        catch (Exception e) {
            log.warn("Exception when trying get app banner", (Throwable)e);
        }
        return new UnknownMobileBanner();
    }

    private static boolean isPluginEnabled() {
        return ComponentAccessor.getPluginAccessor().isPluginEnabled("com.atlassian.jira.mobile.jira-mobile-rest");
    }

    private static boolean isAndroidChromeBrowser(UserAgentUtil.BrowserFamily browserFamily, UserAgentUtil.OperatingSystem.OperatingSystemFamily operatingSystemFamily) {
        return browserFamily == UserAgentUtil.BrowserFamily.CHROME && operatingSystemFamily == UserAgentUtil.OperatingSystem.OperatingSystemFamily.ANDROID;
    }

    private static boolean isIOSSafariBrowser(UserAgentUtil.BrowserFamily browserFamily, UserAgentUtil.OperatingSystem.OperatingSystemFamily operatingSystemFamily) {
        return browserFamily == UserAgentUtil.BrowserFamily.SAFARI && (operatingSystemFamily == UserAgentUtil.OperatingSystem.OperatingSystemFamily.IPAD || operatingSystemFamily == UserAgentUtil.OperatingSystem.OperatingSystemFamily.IPHONE);
    }
}

