/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.thread;

import com.atlassian.core.logging.ThreadLocalErrorCollection;
import com.atlassian.jira.cache.JiraVCacheInitialisationUtils;
import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.event.operation.SpanningOperationHolderImpl;
import com.atlassian.jira.instrumentation.DefaultInstrumentationListenerManager;
import com.atlassian.jira.issue.index.ThreadLocalSearcherCache;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.jira.web.filters.ThreadLocalQueryProfiler;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.TransactionUtil;

public class JiraThreadLocalUtils {
    private static final Logger LOG = Logger.getLogger(JiraThreadLocalUtils.class);
    private static ThreadLocal<AtomicInteger> contextLevel = ThreadLocal.withInitial(() -> new AtomicInteger(0));

    public static void preCall() {
        if (JiraThreadLocalUtils.contextLevelUp()) {
            JiraThreadLocalUtils.before();
        } else if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("Nested JiraThreadLocalUtils context, level: %d, ", contextLevel.get().get()), new Throwable());
        }
    }

    private static boolean contextLevelUp() {
        int level = contextLevel.get().incrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("%s context level up to: %d", JiraThreadLocalUtils.class.getSimpleName(), level), new Throwable());
        }
        return level == 1;
    }

    private static boolean contextLevelDown() {
        if (contextLevel.get().get() == 0) {
            LOG.warn((Object)"Trying to stop an already stopped JiraThreadLocalUtils context", new Throwable());
            return false;
        }
        int level = contextLevel.get().decrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)String.format("%s context level down to: %d", JiraThreadLocalUtils.class.getSimpleName(), level), new Throwable());
        }
        return level == 0;
    }

    public static boolean inContext() {
        return contextLevel.get().get() > 0;
    }

    public static void postCall() {
        JiraThreadLocalUtils.postCall(LOG, null);
    }

    public static void checkClosed(boolean forceClose) {
        if (contextLevel.get().get() > 0) {
            LOG.warn((Object)String.format("%s context should be: %d but is: %d. You can investigate who is responsible for not closing the context by setting the log level to: %s for: %s", JiraThreadLocalUtils.class.getSimpleName(), 0, contextLevel.get().get(), Level.TRACE, JiraThreadLocalUtils.class.getCanonicalName()));
            if (forceClose) {
                LOG.warn((Object)"Force-closing context");
                contextLevel.get().set(1);
                JiraThreadLocalUtils.postCall();
            } else {
                LOG.warn((Object)"Not force-closing context");
            }
        }
        ThreadLocalQueryProfiler.checkClosed(forceClose);
        ThreadLocalSearcherCache.checkClosed(forceClose);
    }

    public static Runnable wrap(Runnable runnable) {
        return () -> {
            JiraThreadLocalUtils.preCall();
            try {
                runnable.run();
            }
            finally {
                JiraThreadLocalUtils.postCall();
            }
        };
    }

    public static void postCall(@Nonnull Logger log, @Nullable JiraThreadLocalUtil.WarningCallback warningCallback) {
        if (JiraThreadLocalUtils.contextLevelDown()) {
            JiraThreadLocalUtils.after(log, warningCallback);
        }
    }

    public static <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            JiraThreadLocalUtils.preCall();
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                JiraThreadLocalUtils.postCall();
            }
        };
    }

    private static void safelyRun(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            LOG.error((Object)("Error when performing thread local operation: " + t.getMessage()), t);
        }
    }

    private static void before() {
        JiraThreadLocalUtils.safelyRun(() -> JiraVCacheInitialisationUtils.initVCache(JiraVCacheInitialisationUtils.getFakeTenant()));
        JiraThreadLocalUtils.safelyRun(ThreadLocalSearcherCache::startSearcherContext);
        JiraThreadLocalUtils.safelyRun(() -> DefaultInstrumentationListenerManager.startContext(Thread.currentThread().getName()));
        JiraThreadLocalUtils.safelyRun(JiraAuthenticationContextImpl::clearRequestCache);
        JiraThreadLocalUtils.safelyRun(SpanningOperationHolderImpl::clearContext);
        JiraThreadLocalUtils.safelyRun(RequestCacheController::startContext);
        JiraThreadLocalUtils.safelyRun(ThreadLocalQueryProfiler::start);
        JiraThreadLocalUtils.safelyRun(ThreadLocalErrorCollection::clear);
    }

    private static void after(@Nonnull Logger log, @Nullable JiraThreadLocalUtil.WarningCallback warningCallback) {
        JiraThreadLocalUtils.safelyRun(ThreadLocalErrorCollection::clear);
        JiraThreadLocalUtils.safelyRun(ThreadLocalQueryProfiler::end);
        JiraThreadLocalUtils.safelyRun(() -> {
            if (!ImportUtils.isIndexIssues()) {
                log.error((Object)"Indexing thread local not cleared. Clearing...");
                ImportUtils.setIndexIssues((boolean)true);
            }
        });
        JiraThreadLocalUtils.safelyRun(() -> {
            if (TransactionUtil.getLocalTransactionConnection() != null) {
                try {
                    if (warningCallback != null) {
                        warningCallback.onOpenTransaction();
                    } else {
                        log.error((Object)"Uncommitted database transaction detected.  Closing...");
                    }
                }
                finally {
                    TransactionUtil.closeAndClearThreadLocalConnection();
                }
            }
        });
        JiraThreadLocalUtils.safelyRun(RequestCacheController::closeContext);
        JiraThreadLocalUtils.safelyRun(SpanningOperationHolderImpl::clearContext);
        JiraThreadLocalUtils.safelyRun(JiraAuthenticationContextImpl::clearRequestCache);
        JiraThreadLocalUtils.safelyRun(DefaultInstrumentationListenerManager::endContext);
        JiraThreadLocalUtils.safelyRun(ThreadLocalSearcherCache::stopAndCloseSearcherContext);
        JiraThreadLocalUtils.safelyRun(JiraVCacheInitialisationUtils::cleanupVCache);
    }
}

