/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.velocity;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.velocity.HttpSessionBackedVelocityRequestSession;
import com.atlassian.jira.util.velocity.RequestContextParameterHolderImpl;
import com.atlassian.jira.util.velocity.SimpleVelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class DefaultVelocityRequestContextFactory
implements VelocityRequestContextFactory {
    private final ApplicationProperties applicationProperties;

    public DefaultVelocityRequestContextFactory(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public DefaultVelocityRequestContextFactory() {
        this(ComponentAccessor.getApplicationProperties());
    }

    public VelocityRequestContext getJiraVelocityRequestContext() {
        VelocityRequestContext cachedRequestContext = this.getCachedContext();
        if (cachedRequestContext != null) {
            return cachedRequestContext;
        }
        return this.createStaticContext();
    }

    public Map<String, Object> getDefaultVelocityParams(Map<String, Object> startingParams, JiraAuthenticationContext authenticationContext) {
        return JiraVelocityUtils.getDefaultVelocityParams(startingParams, authenticationContext);
    }

    public static void cacheVelocityRequestContext(HttpServletRequest request) {
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext(request.getContextPath(), request);
    }

    public void setVelocityRequestContext(HttpServletRequest request) {
        this.setVelocityRequestContext(request.getContextPath(), request);
    }

    public static void cacheVelocityRequestContext(String baseUrl, HttpServletRequest request) {
        RequestContextParameterHolderImpl requestContextParameterHolder = null;
        String canonicalBaseURL = baseUrl;
        HttpSessionBackedVelocityRequestSession session = null;
        if (request != null) {
            requestContextParameterHolder = new RequestContextParameterHolderImpl(request);
            canonicalBaseURL = JiraUrl.constructBaseUrl((HttpServletRequest)request);
            session = new HttpSessionBackedVelocityRequestSession(request);
        }
        SimpleVelocityRequestContext velocityRequestContext = new SimpleVelocityRequestContext(baseUrl, canonicalBaseURL, requestContextParameterHolder, session);
        JiraAuthenticationContextImpl.getRequestCache().put("jira.velocity.request.context", velocityRequestContext);
    }

    public void setVelocityRequestContext(String baseUrl, HttpServletRequest request) {
        DefaultVelocityRequestContextFactory.cacheVelocityRequestContext(baseUrl, request);
    }

    public void cacheVelocityRequestContext(VelocityRequestContext velocityRequestContext) {
        this.setVelocityRequestContext(velocityRequestContext);
    }

    public void setVelocityRequestContext(VelocityRequestContext velocityRequestContext) {
        this.getRequestCache().put("jira.velocity.request.context", velocityRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I, O> O runWithStaticBaseUrl(I input, @Nonnull Function<I, O> runnable) {
        VelocityRequestContext cachedContext = this.getCachedContext();
        this.setVelocityRequestContext(this.createStaticContext());
        try {
            Object object = runnable.apply(input);
            return (O)object;
        }
        finally {
            if (cachedContext == null) {
                this.clearVelocityRequestContext();
            } else {
                this.setVelocityRequestContext(cachedContext);
            }
        }
    }

    public void clearVelocityRequestContext() {
        this.getRequestCache().remove("jira.velocity.request.context");
    }

    @VisibleForTesting
    Map<String, Object> getRequestCache() {
        return JiraAuthenticationContextImpl.getRequestCache();
    }

    private VelocityRequestContext createStaticContext() {
        return new SimpleVelocityRequestContext(this.applicationProperties.getString("jira.baseurl"));
    }

    private VelocityRequestContext getCachedContext() {
        return (VelocityRequestContext)this.getRequestCache().get("jira.velocity.request.context");
    }
}

