/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.xml;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlNode {
    private final Node node;

    public XmlNode(Node node) {
        this.node = node;
    }

    public String getNodeName() {
        return this.node.getNodeName();
    }

    @Nonnull
    public List<XmlNode> getChildren() {
        NodeList childNodes = this.node.getChildNodes();
        ArrayList<XmlNode> children = new ArrayList<XmlNode>(childNodes.getLength());
        for (int i = 0; i < childNodes.getLength(); ++i) {
            children.add(new XmlNode(childNodes.item(i)));
        }
        return children;
    }

    @Nonnull
    public List<XmlNode> getChildren(String name) {
        LinkedList<XmlNode> children = new LinkedList<XmlNode>();
        List<XmlNode> allChildren = this.getChildren();
        for (XmlNode child : allChildren) {
            if (!child.getNodeName().equals(name)) continue;
            children.add(child);
        }
        return children;
    }

    @Nullable
    public XmlNode getFirstChild(String name) {
        List<XmlNode> children = this.getChildren();
        for (XmlNode child : children) {
            if (!child.getNodeName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public String getAttribute(String name) {
        Node attribute;
        NamedNodeMap attributeMap = this.node.getAttributes();
        if (attributeMap != null && (attribute = attributeMap.getNamedItem(name)) != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    public String getTextContent() {
        return this.node.getTextContent();
    }
}

