/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.versioning;

import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.DTO;
import com.atlassian.jira.model.querydsl.JiraRelationalPathBase;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.DateTimeExpression;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class VersioningDao<Q extends JiraRelationalPathBase<?>, D extends DTO> {
    private final QueryDslAccessor queryDslAccessor;
    private final Q entityVersionPathBase;
    private final Class<D> dtoClass;
    private final NumberPath<Long> versionPath;
    private final DateTimePath<Timestamp> updateTimePath;
    private final StringPath deletedFlagPath;
    private final NumberPath<Long> entityIdPath;
    private NumberPath<Long> parentIssueIdPath;

    VersioningDao(QueryDslAccessor queryDslAccessor, Q entityVersionPathBase, Class<D> dtoClass, NumberPath<Long> entityIdPath, NumberPath<Long> parentIssueIdPath, DateTimePath<Timestamp> updateTimePath, NumberPath<Long> versionPath, StringPath deletedFlagPath) {
        this.queryDslAccessor = queryDslAccessor;
        this.entityVersionPathBase = entityVersionPathBase;
        this.dtoClass = dtoClass;
        this.entityIdPath = entityIdPath;
        this.parentIssueIdPath = parentIssueIdPath;
        this.updateTimePath = updateTimePath;
        this.versionPath = versionPath;
        this.deletedFlagPath = deletedFlagPath;
    }

    String getEntityName() {
        return ((JiraRelationalPathBase)((Object)this.entityVersionPathBase)).getEntityName();
    }

    long insertInitialVersionRow(long entityId, @Nullable Long parentIssueId) {
        return this.queryDslAccessor.executeQuery(c -> c.insert((JiraRelationalPathBase<?>)((Object)((Object)this.entityVersionPathBase))).set((Path)this.entityIdPath, (Object)entityId).set((Path)this.parentIssueIdPath, parentIssueId).set((Path)this.versionPath, (Object)1L).set((Path)this.updateTimePath, (Expression)DateTimeExpression.currentTimestamp(Timestamp.class)).set((Path)this.deletedFlagPath, DatabaseUtil.booleanToChar1(Boolean.FALSE)).execute());
    }

    long insertDeleteVersionRow(long entityId) {
        return this.queryDslAccessor.executeQuery(c -> c.insert((JiraRelationalPathBase<?>)((Object)((Object)this.entityVersionPathBase))).set((Path)this.entityIdPath, (Object)entityId).set((Path)this.versionPath, (Object)1L).set((Path)this.updateTimePath, (Expression)DateTimeExpression.currentTimestamp(Timestamp.class)).set((Path)this.deletedFlagPath, DatabaseUtil.booleanToChar1(Boolean.TRUE)).execute());
    }

    long incrementEntityVersionAndUpdateTimestamp(long entityId) {
        return this.queryDslAccessor.executeQuery(c -> c.update((RelationalPath<?>)this.entityVersionPathBase).set(this.versionPath, (Expression)this.versionPath.add((Number)1)).set(this.updateTimePath, (Expression)DateTimeExpression.currentTimestamp(Timestamp.class)).where((Predicate)this.entityIdPath.eq((Object)entityId)).where((Predicate)this.deletedFlagPath.eq((Object)DatabaseUtil.booleanToChar1(Boolean.FALSE))).execute());
    }

    boolean isMarkedAsDeleted(long entityId) {
        return this.queryDslAccessor.executeQuery(c -> ((SQLQuery)((SQLQuery)((SQLQuery)c.newSqlQuery().from(this.entityVersionPathBase)).where((Predicate)this.entityIdPath.eq((Object)entityId))).where((Predicate)this.deletedFlagPath.eq((Object)DatabaseUtil.booleanToChar1(Boolean.TRUE)))).fetchCount()) == 1L;
    }

    public long markDeletedAndUpdateVersion(long entityId) {
        return this.queryDslAccessor.executeQuery(c -> c.update((RelationalPath<?>)this.entityVersionPathBase).set(this.versionPath, (Expression)this.versionPath.add((Number)1)).set(this.updateTimePath, (Expression)DateTimeExpression.currentTimestamp(Timestamp.class)).set((Path)this.deletedFlagPath, (Object)DatabaseUtil.booleanToChar1(Boolean.TRUE)).where((Predicate)this.entityIdPath.eq((Object)entityId)).where((Predicate)this.deletedFlagPath.eq((Object)DatabaseUtil.booleanToChar1(Boolean.FALSE))).execute());
    }

    public long markRelatedToIssueAsDeletedAndUpdateVersion(long parentIssueId) {
        return this.queryDslAccessor.executeQuery(c -> c.update((RelationalPath<?>)this.entityVersionPathBase).set(this.versionPath, (Expression)this.versionPath.add((Number)1)).set(this.updateTimePath, (Expression)DateTimeExpression.currentTimestamp(Timestamp.class)).set((Path)this.deletedFlagPath, (Object)DatabaseUtil.booleanToChar1(Boolean.TRUE)).where((Predicate)this.parentIssueIdPath.eq((Object)parentIssueId)).execute());
    }

    public Optional<Long> getCurrentVersion(long entityId) {
        return Optional.ofNullable(this.queryDslAccessor.executeQuery(c -> (Long)((SQLQuery)((SQLQuery)c.newSqlQuery().select(this.versionPath).from(this.entityVersionPathBase)).where((Predicate)this.entityIdPath.eq((Object)entityId))).fetchOne()));
    }

    public Optional<D> getCurrentEntityVersion(long entityId) {
        return Optional.ofNullable(this.queryDslAccessor.executeQuery(c -> (DTO)((SQLQuery)((SQLQuery)c.newSqlQuery().select(this.allColumns()).from(this.entityVersionPathBase)).where((Predicate)this.entityIdPath.eq((Object)entityId))).fetchOne()));
    }

    public List<D> getEntityVersionsRelatedToIssue(long parentIssueId) {
        return this.queryDslAccessor.executeQuery(c -> ((SQLQuery)((SQLQuery)((SQLQuery)c.newSqlQuery().select(this.allColumns()).from(this.entityVersionPathBase)).where((Predicate)this.parentIssueIdPath.eq((Object)parentIssueId))).where((Predicate)this.deletedFlagPath.eq((Object)DatabaseUtil.booleanToChar1(Boolean.FALSE)))).fetch());
    }

    public long cleanDeletedVersionsOlderThan(Duration ageThreshold) {
        return this.queryDslAccessor.executeQuery(c -> c.delete((RelationalPath<?>)this.entityVersionPathBase).where((Predicate)this.deletedFlagPath.eq((Object)DatabaseUtil.booleanToChar1(Boolean.TRUE))).where((Predicate)this.updateTimePath.before((Expression)SQLExpressions.addSeconds((DateTimeExpression)DateTimeExpression.currentTimestamp(Timestamp.class), (int)((int)(-ageThreshold.getSeconds()))))).execute());
    }

    public long cleanDeletedVersion(long entityId) {
        return this.queryDslAccessor.executeQuery(c -> c.delete((RelationalPath<?>)this.entityVersionPathBase).where((Predicate)this.entityIdPath.eq((Object)entityId)).where((Predicate)this.deletedFlagPath.eq((Object)DatabaseUtil.booleanToChar1(Boolean.TRUE))).execute());
    }

    public long cleanDeletedRelatedVersions(long parentIssueId) {
        return this.queryDslAccessor.executeQuery(c -> c.delete((RelationalPath<?>)this.entityVersionPathBase).where((Predicate)this.parentIssueIdPath.eq((Object)parentIssueId)).execute());
    }

    @VisibleForTesting
    public List<D> fetchAllRows(int limit) {
        Preconditions.checkArgument((limit <= 1000 ? 1 : 0) != 0, (String)"This is a method intended for testing. Loading too many rows might impact the stability of Jira. Maximum number of rows allowed=1000, rows requested=%s", (int)limit);
        return this.queryDslAccessor.executeQuery(c -> ((SQLQuery)c.newSqlQuery().select(this.allColumns()).from(this.entityVersionPathBase)).fetch());
    }

    @VisibleForTesting
    public D fetchOneRow(long entityId) {
        return (D)this.queryDslAccessor.executeQuery(c -> (DTO)((SQLQuery)((SQLQuery)c.newSqlQuery().select(this.allColumns()).from(this.entityVersionPathBase)).where((Predicate)this.entityIdPath.eq((Object)entityId))).fetchOne());
    }

    private ConstructorExpression<D> allColumns() {
        return Projections.constructor(this.dtoClass, (Expression[])new Expression[]{this.entityIdPath, this.parentIssueIdPath, this.updateTimePath, this.versionPath, this.deletedFlagPath});
    }

    @VisibleForTesting
    public long insertNewRow(long entityId, long parentIssueId, LocalDateTime updateTime, long version, String deleted) {
        return this.queryDslAccessor.executeQuery(c -> c.insert((JiraRelationalPathBase<?>)((Object)((Object)this.entityVersionPathBase))).set((Path)this.entityIdPath, (Object)entityId).set((Path)this.parentIssueIdPath, (Object)parentIssueId).set((Path)this.versionPath, (Object)version).set((Path)this.updateTimePath, Timestamp.valueOf(updateTime)).set((Path)this.deletedFlagPath, deleted).execute());
    }

    public void incrementEntityVersionsRelatedToIssue(long parentIssueId) {
        this.queryDslAccessor.executeQuery(c -> c.update((RelationalPath<?>)this.entityVersionPathBase).set(this.versionPath, (Expression)this.versionPath.add((Number)1)).set(this.updateTimePath, (Expression)DateTimeExpression.currentTimestamp(Timestamp.class)).where((Predicate)this.parentIssueIdPath.eq((Object)parentIssueId)).where((Predicate)this.deletedFlagPath.eq((Object)DatabaseUtil.booleanToChar1(Boolean.FALSE))).execute());
    }

    public List<D> findVersionsUpdatedInTheLast(Duration duration) {
        return this.queryDslAccessor.executeQuery(c -> ((SQLQuery)((SQLQuery)c.newSqlQuery().select(this.allColumns()).from(this.entityVersionPathBase)).where((Predicate)this.updateTimePath.after((Expression)SQLExpressions.addSeconds((DateTimeExpression)DateTimeExpression.currentTimestamp(Timestamp.class), (int)((int)(-duration.getSeconds())))))).fetch());
    }

    public Optional<D> getMostRecentlyUpdatedVersion() {
        return Optional.ofNullable(this.queryDslAccessor.executeQuery(c -> (DTO)((SQLQuery)((SQLQuery)c.newSqlQuery().select(this.allColumns()).from(this.entityVersionPathBase)).orderBy(this.updateTimePath.desc())).fetchFirst()));
    }
}

