/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserDefaultSettings;
import com.atlassian.jira.user.UserDefaultSettingsManager;
import com.atlassian.jira.web.action.admin.ViewUserDefaultSettings;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

@WebSudoRequired
public class EditUserDefaultSettings
extends ViewUserDefaultSettings {
    public String preference;
    public String numIssues;
    public boolean emailUser = false;
    public boolean sharePublic;
    private boolean autoWatch = false;

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.preference = this.getApplicationProperties().getDefaultBackedString("user.notifications.mimetype");
        this.autoWatch = !this.getApplicationProperties().getOption("user.autowatch.disabled");
        this.emailUser = this.getApplicationProperties().getOption("user.notify.own.changes");
        return super.doDefault();
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.preference) || !this.preference.equals("html") && !this.preference.equals("text")) {
            this.addError("preference", this.getText("admin.errors.specify.notification.preference"));
        }
        if (TextUtils.stringSet((String)this.numIssues)) {
            try {
                int issues = Integer.parseInt(this.numIssues);
                if (issues <= 0 || issues > 1000) {
                    this.addError("numIssues", this.getText("preferences.issues.per.page.error"));
                }
            }
            catch (NumberFormatException e) {
                this.addError("numIssues", this.getText("admin.errors.num.issues.displayed.must.be.num"));
            }
        }
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        ((UserDefaultSettingsManager)ComponentAccessor.getComponent(UserDefaultSettingsManager.class)).updateSettings(this.getSettings());
        return this.returnComplete("ViewUserDefaultSettings.jspa");
    }

    private UserDefaultSettings getSettings() {
        return new UserDefaultSettings(this.preference, Boolean.valueOf(this.emailUser), Boolean.valueOf(this.sharePublic), this.numIssues != null ? Integer.valueOf(Integer.parseInt(this.numIssues)) : null, Boolean.valueOf(this.autoWatch));
    }

    public Collection getEmailFormats() {
        return EasyList.build((Object)new TextOption("text", this.getText("admin.userdefaults.text")), (Object)new TextOption("html", this.getText("admin.userdefaults.html")));
    }

    public String getSelectedEmailFormat() {
        return this.getApplicationProperties().getString("user.notifications.mimetype");
    }

    public Collection getShareList() {
        return EasyList.build((Object)new TextOption("false", this.getText("admin.common.words.public")), (Object)new TextOption("true", this.getText("admin.common.words.private")));
    }

    public String getShareValue() {
        return String.valueOf(this.getApplicationProperties().getOption("user.default.share.private"));
    }

    public String getPreference() {
        return this.preference;
    }

    public void setPreference(String preference) {
        this.preference = preference;
    }

    public boolean isEmailUser() {
        return this.emailUser;
    }

    public void setEmailUser(boolean emailUser) {
        this.emailUser = emailUser;
    }

    public boolean isSharePublic() {
        return this.sharePublic;
    }

    public void setSharePublic(boolean sharePublic) {
        this.sharePublic = sharePublic;
    }

    public String getNumIssues() {
        return this.numIssues;
    }

    public void setNumIssues(String numIssues) {
        this.numIssues = numIssues;
    }

    public boolean isAutoWatch() {
        return this.autoWatch;
    }

    public void setAutoWatch(boolean autoWatch) {
        this.autoWatch = autoWatch;
    }
}

