/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.cluster;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeChangeEvent;
import com.atlassian.jira.cluster.disasterrecovery.JiraHomeReplicatorService;
import com.atlassian.jira.config.util.SecondaryJiraHome;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.cluster.ReplicationSettings;

public class EditReplicationSettings
extends ReplicationSettings {
    private boolean attachmentsEnabled;
    private boolean pluginsEnabled;
    private boolean indexSnapshotsEnabled;
    private boolean avatarsEnabled;

    public EditReplicationSettings(SecondaryJiraHome secondaryJiraHome, ClusterManager clusterManager, JiraHomeReplicatorService jiraHomeReplicatorService) {
        super(secondaryJiraHome, clusterManager, jiraHomeReplicatorService);
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.attachmentsEnabled = this.getApplicationProperties().getOption(JiraHomeChangeEvent.FileType.ATTACHMENT.getKey());
        this.pluginsEnabled = this.getApplicationProperties().getOption(JiraHomeChangeEvent.FileType.PLUGIN.getKey());
        this.indexSnapshotsEnabled = this.getApplicationProperties().getOption(JiraHomeChangeEvent.FileType.INDEX_SNAPSHOT.getKey());
        this.avatarsEnabled = this.getApplicationProperties().getOption(JiraHomeChangeEvent.FileType.AVATAR.getKey());
        return "input";
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.secondaryJiraHome.applySettings(this.attachmentsEnabled, this.pluginsEnabled, this.indexSnapshotsEnabled, this.avatarsEnabled);
        return this.returnComplete("ReplicationSettings!default.jspa");
    }

    public boolean isAttachmentsEnabled() {
        return this.attachmentsEnabled;
    }

    public void setAttachmentsEnabled(boolean attachmentsEnabled) {
        this.attachmentsEnabled = attachmentsEnabled;
    }

    public boolean isPluginsEnabled() {
        return this.pluginsEnabled;
    }

    public void setPluginsEnabled(boolean pluginsEnabled) {
        this.pluginsEnabled = pluginsEnabled;
    }

    public boolean isIndexSnapshotsEnabled() {
        return this.indexSnapshotsEnabled;
    }

    public void setIndexSnapshotsEnabled(boolean indexSnapshotsEnabled) {
        this.indexSnapshotsEnabled = indexSnapshotsEnabled;
    }

    public boolean isAvatarsEnabled() {
        return this.avatarsEnabled;
    }

    public void setAvatarsEnabled(boolean avatarsEnabled) {
        this.avatarsEnabled = avatarsEnabled;
    }
}

