/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;

public abstract class AbstractEditConfigurationItemAction
extends JiraWebActionSupport {
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private Long fieldConfigId;
    private FieldConfig fieldConfig;
    private ManagedConfigurationItem managedConfigurationItem;

    protected AbstractEditConfigurationItemAction(ManagedConfigurationItemService managedConfigurationItemService) {
        this.managedConfigurationItemService = managedConfigurationItemService;
    }

    public String doDefault() throws Exception {
        if (this.validateFieldLocked()) {
            return "error";
        }
        return super.doDefault();
    }

    public void setFieldConfigId(Long fieldConfigId) {
        this.fieldConfigId = fieldConfigId;
    }

    public Long getFieldConfigId() {
        return this.fieldConfigId;
    }

    public FieldConfig getFieldConfig() {
        if (this.fieldConfig == null && this.fieldConfigId != null) {
            FieldConfigManager fieldConfigManager = (FieldConfigManager)ComponentAccessor.getComponent(FieldConfigManager.class);
            this.fieldConfig = fieldConfigManager.getFieldConfig(this.fieldConfigId);
        }
        return this.fieldConfig;
    }

    public CustomField getCustomField() {
        try {
            return this.getFieldConfig().getCustomField();
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public ConfigurableField<Object> getConfigurableField() {
        return this.getFieldConfig().getConfigurableField();
    }

    public boolean isFieldLocked() {
        return this.getCustomField() != null && !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), this.getManagedConfigurationItem());
    }

    public boolean isFieldManaged() {
        return this.getManagedConfigurationItem().isManaged();
    }

    public String getManagedFieldDescriptionKey() {
        return this.getManagedConfigurationItem().getDescriptionI18nKey();
    }

    protected boolean validateFieldLocked() {
        if (this.isFieldLocked()) {
            this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.alter.configuration.locked", this.getCustomField()), ErrorCollection.Reason.FORBIDDEN);
            return true;
        }
        return false;
    }

    protected ManagedConfigurationItem getManagedConfigurationItem() {
        if (this.managedConfigurationItem == null) {
            this.managedConfigurationItem = this.managedConfigurationItemService.getManagedCustomField(this.getCustomField());
        }
        return this.managedConfigurationItem;
    }
}

