/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.admin.RenderableProperty;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.customfield.CreateValidationResult;
import com.atlassian.jira.bc.customfield.CustomFieldDefinition;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldDescription;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWizardActionSupport;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldContextManagementUtil;
import com.atlassian.jira.web.action.admin.customfields.CustomFieldValidator;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class CreateCustomField
extends JiraWizardActionSupport {
    public static final String FIELD_TYPE_PREFIX = "com.atlassian.jira.plugin.system.customfieldtypes:";
    private String fieldName;
    private String description;
    private String fieldType;
    private String searcher;
    private boolean global = true;
    private boolean basicMode = true;
    private Long[] projectCategories;
    private Long[] projects = new Long[0];
    private String[] issuetypes = new String[]{"-1"};
    private final ProjectManager projectManager;
    private final SubTaskManager subTaskManager;
    private final CustomFieldDescription customFieldDescription;
    private final CustomFieldManager customFieldManager;
    private final ConstantsManager constantsManager;
    private final CustomFieldValidator customFieldValidator;
    private final CustomFieldService customFieldService;
    private List<CustomFieldType<?, ?>> fieldTypes;

    public CreateCustomField(CustomFieldValidator customFieldValidator, ConstantsManager constantsManager, CustomFieldManager customFieldManager, ProjectManager projectManager, SubTaskManager subTaskManager, CustomFieldDescription customFieldDescription, CustomFieldService customFieldService) {
        this.customFieldValidator = customFieldValidator;
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.projectManager = projectManager;
        this.subTaskManager = subTaskManager;
        this.customFieldDescription = customFieldDescription;
        this.customFieldService = customFieldService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        String url = !this.isFinishClicked() && this.isNextClicked() ? this.doCustomFieldType() : (this.isFinishClicked() ? this.doAddDetails() : "input");
        if (!this.invalidInput()) {
            super.doExecute();
        }
        return url;
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doCustomFieldType() throws Exception {
        this.addErrorCollection(this.customFieldValidator.validateType(this.getFieldType()));
        if (this.invalidInput()) {
            return "input";
        }
        return "details";
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doAddDetails() throws Exception {
        CustomFieldDefinition.Builder builder = CustomFieldDefinition.builder().name(this.getFieldName()).description(this.getDescription()).cfType(this.getFieldType()).searcherKey(this.getSearcher()).isGlobal(this.isGlobal()).isAllIssueTypes(this.isGlobalIssueTypes(this.getIssuetypes())).addProjectIds(this.getProjects()).addIssueTypeIds(this.getIssuetypes());
        ServiceOutcome outcome = this.customFieldService.validateCreate(this.getLoggedInUser(), builder.build());
        if (!outcome.isValid()) {
            this.addErrorCollection(outcome.getErrorCollection());
            return "details";
        }
        ServiceOutcome customFieldServiceOutcome = this.customFieldService.create((CreateValidationResult)outcome.getReturnedValue());
        return this.getRedirect("AssociateFieldToScreens!default.jspa?fieldId=" + ((CustomField)customFieldServiceOutcome.getReturnedValue()).getId() + "&returnUrl=ViewCustomFields.jspa");
    }

    private boolean isGlobalIssueTypes(String[] issueTypes) {
        for (String issuetype : issueTypes) {
            if (!"-1".equals(issuetype)) continue;
            return true;
        }
        return false;
    }

    public Collection<CustomFieldType<?, ?>> getFieldTypes() {
        if (this.fieldTypes == null) {
            this.fieldTypes = Lists.newArrayList((Iterable)this.customFieldService.getCustomFieldTypesForUser(this.getLoggedInUser()));
        }
        return this.fieldTypes;
    }

    public List getSearchers() {
        return this.customFieldManager.getCustomFieldSearchers(this.customFieldManager.getCustomFieldType(this.getFieldType()));
    }

    public RenderableProperty getDescriptionProperty() {
        return this.customFieldDescription.createRenderablePropertyFor((CustomField)null);
    }

    public CustomFieldType getCustomFieldType() {
        return this.customFieldManager.getCustomFieldType(this.getFieldType());
    }

    public Collection<Project> getAllProjects() throws Exception {
        return this.projectManager.getProjectObjects();
    }

    public Collection getAllIssueTypes() throws Exception {
        if (this.subTaskManager.isSubTasksEnabled()) {
            return this.constantsManager.getAllIssueTypeObjects();
        }
        return this.constantsManager.getRegularIssueTypeObjects();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public boolean isFieldTypeValid() {
        return this.customFieldValidator.isValidType(this.getFieldType());
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getSearcher() {
        List searchers;
        if (StringUtils.isEmpty((CharSequence)this.searcher) && StringUtils.isNotEmpty((CharSequence)this.fieldType) && (searchers = this.getSearchers()) != null && !searchers.isEmpty()) {
            this.searcher = ((CustomFieldSearcher)searchers.iterator().next()).getDescriptor().getCompleteKey();
        }
        return this.searcher;
    }

    public void setSearcher(String searcher) {
        this.searcher = searcher;
    }

    public Long[] getProjects() {
        return this.projects;
    }

    public void setProjects(Long[] projects) {
        this.projects = projects;
    }

    public String[] getIssuetypes() {
        return this.issuetypes;
    }

    public void setIssuetypes(String[] issuetypes) {
        this.issuetypes = issuetypes;
    }

    public Map<String, String> getGlobalContextOption() {
        return CustomFieldContextManagementUtil.getGlobalContextOption();
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public boolean isBasicMode() {
        return this.basicMode;
    }

    public void setBasicMode(boolean basicMode) {
        this.basicMode = basicMode;
    }

    public Long[] getProjectCategories() {
        return this.projectCategories;
    }

    public void setProjectCategories(Long[] projectCategories) {
        this.projectCategories = projectCategories;
    }

    @Override
    public int getTotalSteps() {
        return 2;
    }
}

