/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.converters.DatePickerConverter;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.DefaultValueField;
import com.atlassian.jira.issue.fields.FieldId;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.admin.customfields.AbstractEditConfigurationItemAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import webwork.action.Action;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditCustomFieldDefaults
extends AbstractEditConfigurationItemAction {
    private final Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    private Long fieldConfigSchemeId;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final DCFeatureLicenseChecker licenseChecker;

    public EditCustomFieldDefaults(FieldLayoutManager fieldLayoutManager, FieldConfigSchemeManager fieldConfigSchemeManager, ManagedConfigurationItemService managedConfigurationItemService, DCFeatureLicenseChecker licenseChecker) {
        super(managedConfigurationItemService);
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.licenseChecker = licenseChecker;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (this.validateDefaultValueFieldSupport() || this.validateDefaultValueDisabled()) {
            return "error";
        }
        EditCustomFieldDefaults.populateDefaults(this.getFieldConfig(), this.fieldValuesHolder);
        return super.doDefault();
    }

    public static void populateDefaults(FieldConfig config, Map<String, Object> customFieldValuesHolder) {
        ConfigurableField configurableField = config.getConfigurableField();
        if (configurableField instanceof DefaultValueField) {
            DefaultValueField defaultValueSupport = (DefaultValueField)configurableField;
            defaultValueSupport.getDefaultValueOperations().populateDefaults(config, customFieldValuesHolder);
        }
    }

    protected void doValidation() {
        if (this.validateFieldLocked()) {
            return;
        }
        if (this.validateDefaultValueFieldSupport()) {
            return;
        }
        if (this.validateDefaultValueDisabled()) {
            return;
        }
        DefaultValueField<Object> defaultValueField = this.getDefaultValueField();
        if (defaultValueField == null) {
            this.addErrorMessage(this.getText("admin.issuefields.config.fieldnotfound"));
            return;
        }
        Map params = ActionContext.getParameters();
        HashMap modifiableParams = Maps.newHashMap((Map)params);
        modifiableParams.put(CustomFieldUtils.createSearchParam((String)defaultValueField.getId(), (String)CustomFieldUtils.getParamKeyRequireProjectIds()), new String[]{Boolean.TRUE.toString()});
        defaultValueField.getDefaultValueOperations().validateFromActionParams(this.getFieldConfig(), (Map)modifiableParams, (ErrorCollection)this);
        if (this.hasAnyErrors()) {
            defaultValueField.populateFromParams(this.fieldValuesHolder, ActionContext.getParameters());
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        DefaultValueField<Object> defaultValueField = this.getDefaultValueField();
        HashMap map = new HashMap();
        ActionContext.getContext();
        Map actionParams = ActionContext.getParameters();
        try {
            if ("true".equals(ParameterUtils.getStringParam((Map)actionParams, (String)"useCurrentDate"))) {
                defaultValueField.getDefaultValueOperations().setDefaultValue(this.getFieldConfig(), (Object)DatePickerConverter.USE_NOW_DATE);
            } else {
                defaultValueField.populateFromParams(map, actionParams);
                Object fieldDefaultValue = defaultValueField.getValueFromParams(map);
                defaultValueField.getDefaultValueOperations().setDefaultValue(this.getFieldConfig(), fieldDefaultValue);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error while saving default value", (Throwable)e);
            this.addErrorMessage(this.getText("admin.issuefields.customfields.set.defaults.exception", this.getErrorDetail(e)));
            defaultValueField.populateFromParams(this.fieldValuesHolder, ActionContext.getParameters());
            return "error";
        }
        return this.getRedirect("ViewCustomFields.jspa");
    }

    private String getErrorDetail(Exception e) {
        for (Throwable currentThrowable = e; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            if (!(currentThrowable instanceof SQLException)) continue;
            return StringUtils.defaultString((String)currentThrowable.getMessage()).trim();
        }
        return StringUtils.defaultString((String)e.getMessage());
    }

    public String getCustomFieldHtml() {
        DefaultValueField<Object> defaultValueField = this.getDefaultValueField();
        if (defaultValueField != null) {
            FieldConfig config = this.getFieldConfig();
            Map displayParameters = MapBuilder.build((Object)"defaultScreen", (Object)"true", (Object)"objectValue", (Object)defaultValueField.getDefaultValueOperations().getDefaultValue(config));
            FieldConfigScheme fieldConfigScheme = this.fieldConfigSchemeManager.getFieldConfigScheme(this.getFieldConfigSchemeId());
            Project singleProject = null;
            IssueType singleIssueType = null;
            if (fieldConfigScheme != null) {
                Collection associatedIssueTypes;
                List associatedProjects = fieldConfigScheme.getAssociatedProjectObjects();
                if (associatedProjects != null && associatedProjects.size() == 1) {
                    singleProject = (Project)associatedProjects.iterator().next();
                }
                if ((associatedIssueTypes = fieldConfigScheme.getAssociatedIssueTypeObjects()) != null && associatedIssueTypes.size() == 1) {
                    singleIssueType = (IssueType)associatedIssueTypes.iterator().next();
                }
            }
            FieldLayoutItem fieldLayoutItem = null;
            try {
                if (singleProject != null && singleIssueType != null) {
                    FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(singleProject, singleIssueType.getId());
                    fieldLayoutItem = fieldLayout.getFieldLayoutItem(config.getConfigurableField().getId());
                }
            }
            catch (DataAccessException ex) {
                this.log.warn((Object)("Unable to resolve a field layout item when setting the default value of custom field with id: " + config.getConfigurableField().getId()), (Throwable)ex);
            }
            return defaultValueField.getDefaultValueOperations().getEditHtml(config, this.fieldValuesHolder, (Action)this, displayParameters, fieldLayoutItem);
        }
        return null;
    }

    private boolean isLicensedForDefaultValues() {
        return this.licenseChecker.isEnabled(JiraFeatureFlagRegistrar.DEFAULT_VALUES_FOR_SYSTEM_FIELDS);
    }

    public Long getFieldConfigSchemeId() {
        return this.fieldConfigSchemeId;
    }

    public void setFieldConfigSchemeId(Long fieldConfigSchemeId) {
        this.fieldConfigSchemeId = fieldConfigSchemeId;
    }

    @Nullable
    private DefaultValueField<Object> getDefaultValueField() {
        ConfigurableField<Object> configurableField = this.getConfigurableField();
        if (configurableField instanceof DefaultValueField) {
            return (DefaultValueField)configurableField;
        }
        return null;
    }

    private boolean validateDefaultValueFieldSupport() {
        if (!this.isDefaultValueSupported()) {
            this.addErrorMessage(this.getText("admin.issuefields.customfields.set.defaults.not.supported.for.field"), ErrorCollection.Reason.VALIDATION_FAILED);
            return true;
        }
        return false;
    }

    public boolean isDefaultValueSupported() {
        DefaultValueField<Object> defaultValueField = this.getDefaultValueField();
        return defaultValueField != null && defaultValueField.getDefaultValueOperations().isSupport();
    }

    public boolean isDefaultValueDisabled() {
        ConfigurableField<Object> configurableField = this.getConfigurableField();
        FieldId fieldId = FieldId.fromFullId(configurableField.getId());
        if (fieldId.isSystemField()) {
            return !this.isLicensedForDefaultValues();
        }
        return false;
    }

    private boolean validateDefaultValueDisabled() {
        if (this.isDefaultValueDisabled()) {
            this.addErrorMessage(this.getText("admin.issuefields.customfields.set.defaults.error.not.licensed", this.getConfigurableField().getName()), ErrorCollection.Reason.FORBIDDEN);
            return true;
        }
        return false;
    }

    public boolean isEditDefaultValueAvailable() {
        return !this.isFieldLocked() && this.isDefaultValueSupported() && !this.isDefaultValueDisabled();
    }
}

