/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.admin.importer.project.AbstractProjectImportProgress;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportProgressTrackerUtil;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

@WebSudoRequired
public class ProjectImportBackupOverviewProgress
extends AbstractProjectImportProgress<BackupOverview> {
    private final TaskManager taskManager;

    public ProjectImportBackupOverviewProgress(TaskManager taskManager, TaskDescriptorBean.Factory factory, JiraPageBuilderService jiraPageBuilderService, ProjectImportProgressTrackerUtil projectImportProgressTrackerUtil) {
        super(taskManager, factory, jiraPageBuilderService, projectImportProgressTrackerUtil);
        this.taskManager = taskManager;
    }

    @Override
    protected boolean taskIsComplete() {
        return ProjectImportBean.getProjectImportBeanFromSession().getBackupOverview() != null;
    }

    @Override
    protected String handleFinishedTask(TaskDescriptorBean<BackupOverview> ourTask) throws ExecutionException, InterruptedException {
        BackupOverview backupOverview = ourTask.getResult();
        if (backupOverview == null) {
            return this.getRedirect("ProjectImportSelectBackup!errorFromProgress.jspa");
        }
        ProjectImportBean projectImportBean = ProjectImportBean.getProjectImportBeanFromSession();
        this.taskManager.removeTask(projectImportBean.getTaskProgressInformation().getTaskId());
        projectImportBean.getTaskProgressInformation().setTaskId(null);
        projectImportBean.getTaskProgressInformation().setErrorCollection(null);
        projectImportBean.setBackupOverview(backupOverview);
        return this.getRedirect(this.getRedirectOnComplete());
    }

    @Override
    protected String getSubmitUrl() {
        return "ProjectImportBackupOverviewProgress.jspa";
    }

    @Override
    @ActionViewData
    public List<Map<String, Object>> getProgressTrackerSteps() {
        return this.getProgressTrackerSteps(ProjectImportProgressTrackerUtil.Page.SELECT_BACKUP);
    }
}

