/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.FieldLayoutSchemeHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.List;

@WebSudoRequired
public class SelectFieldLayoutScheme
extends JiraWebActionSupport {
    private final ProjectManager projectManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final ReindexMessageManager reindexMessageManager;
    private final FieldLayoutSchemeHelper fieldLayoutSchemeHelper;
    private Long projectId;
    private Long schemeId;
    private List fieldLayoutSchemes;

    public SelectFieldLayoutScheme(ProjectManager projectManager, FieldLayoutManager fieldLayoutManager, ReindexMessageManager reindexMessageManager, FieldLayoutSchemeHelper fieldLayoutSchemeHelper) {
        this.projectManager = projectManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
        this.fieldLayoutSchemeHelper = (FieldLayoutSchemeHelper)Assertions.notNull((String)"fieldLayoutSchemeHelper", (Object)fieldLayoutSchemeHelper);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        this.validateId();
        if (!this.invalidInput()) {
            FieldConfigurationScheme fieldConfigurationScheme = this.fieldLayoutManager.getFieldConfigurationScheme(this.getProject());
            if (fieldConfigurationScheme != null) {
                this.setSchemeId(fieldConfigurationScheme.getId());
            } else {
                this.setSchemeId(null);
            }
        }
        return "input";
    }

    protected void doValidation() {
        this.validateId();
        if (!this.invalidInput() && this.getSchemeId() != null && this.getFieldConfigurationScheme() == null) {
            this.addError("schemeId", this.getText("admin.errors.fieldlayout.invalid.scheme.id"));
        }
    }

    private void validateId() {
        if (this.getProjectId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
        } else if (this.getProject() == null) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.invalid.id2"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        FieldConfigurationScheme currentFieldConfigurationScheme = this.fieldLayoutManager.getFieldConfigurationScheme(this.getProject());
        Long currentFieldConfigurationSchemeId = currentFieldConfigurationScheme == null ? null : currentFieldConfigurationScheme.getId();
        Long newFieldConfigurationSchemeId = this.getSchemeId();
        if (this.fieldLayoutSchemeHelper.doesChangingFieldLayoutSchemeForProjectRequireMessage(this.getLoggedInUser(), this.getProjectId(), currentFieldConfigurationSchemeId, newFieldConfigurationSchemeId)) {
            this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.field.configuration");
        }
        if (currentFieldConfigurationScheme != null) {
            this.fieldLayoutManager.removeSchemeAssociation(this.getProject(), currentFieldConfigurationSchemeId);
        }
        if (newFieldConfigurationSchemeId != null) {
            this.fieldLayoutManager.addSchemeAssociation(this.getProject(), newFieldConfigurationSchemeId);
        }
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getKey() + "/fields");
    }

    private FieldConfigurationScheme getFieldConfigurationScheme() {
        return this.fieldLayoutManager.getFieldConfigurationScheme(this.getSchemeId());
    }

    public Project getProject() {
        return this.projectManager.getProjectObj(this.getProjectId());
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public Collection getFieldLayoutSchemes() {
        if (this.fieldLayoutSchemes == null) {
            this.fieldLayoutSchemes = this.fieldLayoutManager.getFieldLayoutSchemes();
        }
        return this.fieldLayoutSchemes;
    }
}

