/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens.schemes.issuetype;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@WebSudoRequired
public class AddIssueTypeScreenScreenSchemeAssociation
extends JiraWebActionSupport {
    private Long id;
    private String issueTypeId;
    private Long fieldScreenSchemeId;
    private IssueTypeScreenScheme issueTypeScreenScheme;
    private List<IssueType> addableIssueTypes;
    private Collection<IssueType> allRelevantIssueTypeObjects;
    private Collection<FieldScreenScheme> fieldScreenSchemes;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final FieldScreenFactory fieldScreenFactory;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;

    public AddIssueTypeScreenScreenSchemeAssociation(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, FieldScreenFactory fieldScreenFactory, FieldScreenSchemeManager fieldScreenSchemeManager, ConstantsManager constantsManager, SubTaskManager subTaskManager) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.fieldScreenFactory = fieldScreenFactory;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.constantsManager = constantsManager;
        this.subTaskManager = subTaskManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.getIssueTypeId() == null) {
            this.addError("issueTypeId", this.getText("admin.errors.screens.specify.issue.type"));
            return "error";
        }
        if (this.getFieldScreenSchemeId() == null) {
            this.addError("fieldScreenSchemeId", this.getText("admin.errors.screens.please.specify.a.screen.name"));
            return "error";
        }
        IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = this.fieldScreenFactory.createIssueTypeScreenSchemeEntity();
        issueTypeScreenSchemeEntity.setIssueTypeId(this.getIssueTypeId());
        issueTypeScreenSchemeEntity.setFieldScreenScheme(this.fieldScreenSchemeManager.getFieldScreenScheme(this.getFieldScreenSchemeId()));
        this.getIssueTypeScreenScheme().addEntity(issueTypeScreenSchemeEntity);
        return this.returnComplete("ConfigureIssueTypeScreenScheme.jspa?id=" + this.getId());
    }

    public List<IssueType> getAddableIssueTypes() {
        if (this.addableIssueTypes == null) {
            this.addableIssueTypes = new LinkedList<IssueType>(this.getAllRelevantIssueTypeObjects());
            Iterator<IssueType> iterator = this.addableIssueTypes.iterator();
            while (iterator.hasNext()) {
                IssueType issueType = iterator.next();
                if (this.getIssueTypeScreenScheme().getEntity(issueType.getId()) == null) continue;
                iterator.remove();
            }
        }
        return this.addableIssueTypes;
    }

    private Collection<IssueType> getAllRelevantIssueTypeObjects() {
        if (this.allRelevantIssueTypeObjects == null) {
            this.allRelevantIssueTypeObjects = this.subTaskManager.isSubTasksEnabled() ? this.constantsManager.getAllIssueTypeObjects() : this.constantsManager.getRegularIssueTypeObjects();
        }
        return this.allRelevantIssueTypeObjects;
    }

    public Collection<FieldScreenScheme> getFieldScreenSchemes() {
        if (this.fieldScreenSchemes == null) {
            this.fieldScreenSchemes = this.fieldScreenSchemeManager.getFieldScreenSchemes();
        }
        return this.fieldScreenSchemes;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public Long getFieldScreenSchemeId() {
        return this.fieldScreenSchemeId;
    }

    public void setFieldScreenSchemeId(Long fieldScreenSchemeId) {
        this.fieldScreenSchemeId = fieldScreenSchemeId;
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme() {
        if (this.issueTypeScreenScheme == null) {
            this.issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(this.getId());
        }
        return this.issueTypeScreenScheme;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

