/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.operation.BulkMigrateOperation;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.event.operation.SpanningOperationType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.issue.bulkedit.BulkMigrate;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import webwork.action.Action;
import webwork.action.ActionContext;

@WebSudoRequired
public class MigrateIssueTypes
extends BulkMigrate {
    private static final String BUTTON_NAME_NEXT = "nextBtn";
    private static final String BUTTON_NAME_PREVIOUS = "previousBtn";
    protected int currentStep = 1;
    protected String nextBtn;
    protected String previousBtn;
    protected String finishButton;

    public MigrateIssueTypes(SearchService searchService, BulkMoveOperation bulkMoveOperation, FieldManager fieldManager, WorkflowManager workflowManager, ConstantsManager constantsManager, IssueFactory issueFactory, BulkMigrateOperation bulkMigrateOperation, PermissionManager permissionManager, BulkEditBeanSessionHelper bulkEditBeanSessionHelper, TaskManager taskManager, I18nHelper i18nHelper, PageBuilderService pageBuilderService, IssueService issueService) {
        super(searchService, bulkMoveOperation, fieldManager, workflowManager, constantsManager, issueFactory, bulkMigrateOperation, permissionManager, bulkEditBeanSessionHelper, taskManager, i18nHelper, pageBuilderService, issueService);
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    @SupportedMethods(value={RequestMethod.POST})
    public String doStart() throws Exception {
        return this.progressSteps();
    }

    @Override
    @SupportedMethods(value={RequestMethod.POST})
    public String doChooseContext() throws Exception {
        this.getBulkEditBean().resetMoveData();
        this.getBulkMigrateOperation().chooseContextNoValidate(this.getRootBulkEditBean(), this.getLoggedInUser());
        Set invalidIssues = this.getBulkEditBean().getInvalidIssues();
        if (invalidIssues != null && !invalidIssues.isEmpty()) {
            for (Issue invalidIssue : invalidIssues) {
                this.addErrorMessage(this.getText("admin.errors.issuetypes.issue.has.nonexistent.status", "'" + invalidIssue.getKey() + "'", invalidIssue.getStatusId()));
            }
            return "error";
        }
        this.progressSteps();
        if (this.currentStep == 1) {
            return "start";
        }
        if (this.isPreviousClicked()) {
            this.getRootBulkEditBean().getRelatedMultiBulkMoveBean().progressToPreviousBulkEditBean();
            return "previous";
        }
        if (!this.getBulkMigrateOperation().isStatusValid(this.getRootBulkEditBean())) {
            return "choosestatus";
        }
        return "success";
    }

    @Override
    @SupportedMethods(value={RequestMethod.POST})
    public String doChooseStatus() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkMigrateOperation().setStatusFields(this.getCurrentRootBulkEditBean());
        return this.progressSteps();
    }

    @Override
    @SupportedMethods(value={RequestMethod.POST})
    public String doSetFields() throws Exception {
        this.getBulkMigrateOperation().validatePopulateFields(this.getRootBulkEditBean(), (I18nHelper)this, (ErrorCollection)this);
        if (this.invalidInput()) {
            return "input";
        }
        this.progressSteps();
        if (this.currentStep == this.getTotalSteps()) {
            return "confirm";
        }
        if (this.isPreviousClicked()) {
            if (!this.getBulkMigrateOperation().isStatusValid(this.getRootBulkEditBean())) {
                return "choosestatus";
            }
            return "previous";
        }
        this.getRootBulkEditBean().getRelatedMultiBulkMoveBean().progressToNextBulkEditBean();
        return "success";
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doPerform() throws Exception {
        BulkEditBean rootBulkEditBean;
        if (!this.isFinishClicked()) {
            return this.progressSteps();
        }
        BulkMigrateOperation bulkMigrateOperation = this.getBulkMigrateOperation();
        if (!bulkMigrateOperation.canPerform(rootBulkEditBean = this.getRootBulkEditBean(), this.getLoggedInUser())) {
            this.addErrorMessage(this.getText("bulk.edit.cannotperform.error", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            return "input";
        }
        MultiBulkMoveBean multiBulkMoveBean = this.getMultiBulkMoveBean();
        multiBulkMoveBean.getExecutableAction().run();
        String taskName = this.getText("bulk.operation.progress.taskname.migrate", rootBulkEditBean.getSelectedIssuesIncludingSubTasks().size());
        rootBulkEditBean.setRedirectUrl(multiBulkMoveBean.getFinalLocation());
        return this.submitBulkOperationTask(rootBulkEditBean, bulkMigrateOperation, taskName, SpanningOperation.builder().type(SpanningOperationType.BULK_MIGRATE_ISSUE_TYPES).generatedId().build());
    }

    @Override
    public IssueContext getCurrentIssueContext() {
        return this.getMultiBulkMoveBean().getCurrentIssueContext();
    }

    public int getTotalSteps() {
        return this.getMultiBulkMoveBean().getIssuesInContext().size() * 2 + 2 + this.getMultiBulkMoveBean().getNumberOfStatusChangeRequired(this.bulkMoveOperation);
    }

    public String getIssueTypeEditHtml() {
        IssueTypeField issueTypeField = this.fieldManager.getIssueTypeField();
        final IssueType issueType = this.getBulkEditBean().getTargetIssueType();
        OperationContext operationContext = new OperationContext(){

            public Map<String, Object> getFieldValuesHolder() {
                return MapBuilder.build((Object)"issuetype", (Object)(issueType != null ? issueType.getId() : ""));
            }

            public IssueOperation getIssueOperation() {
                return MigrateIssueTypes.this.getBulkMigrateOperation();
            }
        };
        List options = !this.getBulkEditBean().isSubTaskCollection() ? this.getMultiBulkMoveBean().getRegularOptions() : this.getMultiBulkMoveBean().getSubTaskOptions();
        return issueTypeField.getEditHtml(operationContext, (Action)this, options);
    }

    protected String progressSteps() throws Exception {
        if (this.isPreviousClicked()) {
            --this.currentStep;
        } else if (this.isNextClicked()) {
            ++this.currentStep;
        }
        if (this.isPreviousClicked()) {
            return "previous";
        }
        if (this.isNextClicked()) {
            return "success";
        }
        return "input";
    }

    protected boolean isPreviousClicked() {
        return this.isButtonClickedByName(BUTTON_NAME_PREVIOUS);
    }

    protected boolean isNextClicked() {
        return this.isButtonClickedByName(BUTTON_NAME_NEXT);
    }

    protected boolean isFinishClicked() {
        return this.isNextClicked() && this.getCurrentStep() >= this.getTotalSteps();
    }

    protected boolean isButtonClickedByName(String name) {
        return StringUtils.isNotBlank((CharSequence)ParameterUtils.getStringParam((Map)ActionContext.getParameters(), (String)name));
    }

    protected boolean isButtonClicked(String buttonValue, String buttonName) {
        if (buttonValue == null) {
            return false;
        }
        return buttonValue.toLowerCase().indexOf(buttonName.toLowerCase()) >= 0;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public String getNextBtn() {
        return this.nextBtn;
    }

    public void setNextBtn(String nextBtn) {
        this.nextBtn = nextBtn;
    }

    public String getPreviousBtn() {
        return this.previousBtn;
    }

    public void setPreviousBtn(String previousBtn) {
        this.previousBtn = previousBtn;
    }

    public String getFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(String finishButton) {
        this.finishButton = finishButton;
    }
}

