/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.issue.comparator.ProjectNameComparator;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProjectIssueTypeSchemeHelper {
    private final IssueTypeSchemeManager schemeManager;
    private final JiraAuthenticationContext authContext;
    private final ProjectFactory projectFactory;
    private final ProjectService projectService;
    private final PermissionManager permissionManager;

    public ProjectIssueTypeSchemeHelper(ProjectService projectService, IssueTypeSchemeManager schemeManager, JiraAuthenticationContext authContext, ProjectFactory projectFactory, PermissionManager permissionManager) {
        this.projectService = projectService;
        this.schemeManager = schemeManager;
        this.authContext = authContext;
        this.projectFactory = projectFactory;
        this.permissionManager = permissionManager;
    }

    List<Project> getProjectsUsingScheme(FieldConfigScheme configScheme) {
        ArrayList<Project> associatedProjects;
        if (this.schemeManager.isDefaultIssueTypeScheme(configScheme)) {
            Long defaultId = configScheme.getId();
            associatedProjects = new ArrayList<Project>();
            for (Project project : this.getEditableProjects()) {
                FieldConfigScheme projectScheme = this.schemeManager.getConfigScheme(project);
                if (projectScheme != null && !defaultId.equals(projectScheme.getId())) continue;
                associatedProjects.add(project);
            }
        } else {
            ApplicationUser user = this.authContext.getUser();
            List allAssociated = configScheme.getAssociatedProjectObjects();
            associatedProjects = new ArrayList(allAssociated.size());
            for (Project project : allAssociated) {
                if (!this.hasEditPermission(user, project)) continue;
                associatedProjects.add(project);
            }
        }
        Collections.sort(associatedProjects, ProjectNameComparator.COMPARATOR);
        return associatedProjects;
    }

    boolean hasEditPermission(ApplicationUser user, Project project) {
        return ProjectAction.VIEW_PROJECT_CONFIG.hasPermission(this.permissionManager, user, project);
    }

    private List<Project> getEditableProjects() {
        ServiceOutcome allProjectsForAction = this.projectService.getAllProjectsForAction(this.authContext.getUser(), ProjectAction.VIEW_PROJECT_CONFIG);
        if (allProjectsForAction.isValid()) {
            return (List)allProjectsForAction.getReturnedValue();
        }
        return Collections.emptyList();
    }
}

