/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.IssueTypeService;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.action.admin.constants.AbstractViewConstants;
import com.atlassian.jira.web.action.admin.issuetypes.AddIssueTypeAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.ManageableOptionType;
import com.atlassian.jira.web.action.admin.issuetypes.events.IssueTypeCreatedFromViewIssueTypesPageEvent;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class ViewIssueTypes
extends AbstractViewConstants<IssueType>
implements AddIssueTypeAction {
    public static final String NEW_ISSUE_TYPE_DEFAULT_ICON = "/images/icons/issuetypes/genericissue.png";
    private String style;
    private final FieldManager fieldManager;
    private final FieldConfigSchemeManager configSchemeManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final IssueTypeManageableOption issueTypeManageableOption;
    private final EventPublisher eventPublisher;
    private final IssueTypeService issueTypeService;

    public ViewIssueTypes(FieldManager fieldManager, FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, TranslationManager translationManager, IssueTypeManageableOption issueTypeManageableOption, EventPublisher eventPublisher, IssueTypeService issueTypeService) {
        super(translationManager);
        this.fieldManager = fieldManager;
        this.configSchemeManager = configSchemeManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.issueTypeManageableOption = issueTypeManageableOption;
        this.eventPublisher = eventPublisher;
        this.issueTypeService = issueTypeService;
        this.setIconurl(NEW_ISSUE_TYPE_DEFAULT_ICON);
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @Override
    protected String getConstantEntityName() {
        return "IssueType";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.issuetype.lowercase");
    }

    @Override
    protected Collection<IssueType> getConstants() {
        return ImmutableList.copyOf((Iterable)this.issueTypeService.getIssueTypes(this.getLoggedInUser()));
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshIssueTypes();
        this.fieldManager.refresh();
    }

    @Override
    protected String getIssueConstantField() {
        return "type";
    }

    @Override
    protected IssueType getConstant(String id) {
        return (IssueType)this.issueTypeService.getIssueType(this.getLoggedInUser(), id).getOrNull();
    }

    @Override
    protected String getRedirectPage() {
        return "ViewIssues.jspa";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doAddIssueType() throws Exception {
        boolean isSubTask = "jira_subtask".equals(this.getStyle());
        IssueTypeService.IssueTypeCreateInput typeInput = IssueTypeService.IssueTypeCreateInput.builder().setDescription(this.getDescription()).setName(this.getName()).setType(isSubTask ? IssueTypeService.IssueTypeCreateInput.Type.SUBTASK : IssueTypeService.IssueTypeCreateInput.Type.STANDARD).build();
        IssueTypeService.CreateValidationResult createIssueTypeValidationResult = this.issueTypeService.validateCreateIssueType(this.getLoggedInUser(), typeInput);
        if (createIssueTypeValidationResult.isValid()) {
            this.issueTypeService.createIssueType(this.getLoggedInUser(), createIssueTypeValidationResult);
            this.eventPublisher.publish((Object)new IssueTypeCreatedFromViewIssueTypesPageEvent());
            return this.redirectToView();
        }
        this.addErrors(createIssueTypeValidationResult.getErrorCollection().getErrors());
        return "error";
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doAddNewIssueType() {
        return "input";
    }

    @Override
    protected void addConstant() throws GenericEntityException {
        throw new UnsupportedOperationException("Use doAddIssueType command instead!");
    }

    @Override
    protected String redirectToView() {
        return this.returnCompleteWithInlineRedirect("ViewIssueTypes.jspa");
    }

    @Override
    protected String getDefaultPropertyName() {
        return "jira.constant.default.issue.type";
    }

    @Override
    public ManageableOptionType getManageableOption() {
        return this.issueTypeManageableOption;
    }

    @Override
    public List<Pair<String, Object>> getHiddenFields() {
        return Collections.emptyList();
    }

    public String getActionType() {
        return "view";
    }

    public Collection getAllRelatedSchemes(String id) {
        return this.issueTypeSchemeManager.getAllRelatedSchemes(id);
    }

    public List getSchemes() {
        return this.configSchemeManager.getConfigSchemesForField((ConfigurableField)this.fieldManager.getIssueTypeField());
    }

    public FieldConfigScheme getDefaultScheme() {
        return this.issueTypeSchemeManager.getDefaultIssueTypeScheme();
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public String getSubmitUrl() {
        return "AddIssueType.jspa";
    }

    @Override
    public String getCancelUrl() {
        return "ViewIssueTypes.jspa";
    }
}

