/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.linking;

import com.atlassian.jira.auditing.handlers.IssueLinkingHandler;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeDestroyer;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

@WebSudoRequired
public class DeleteLinkType
extends JiraWebActionSupport {
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkTypeDestroyer issueLinkTypeDestroyer;
    private final IssueLinkManager issueLinkManager;
    private final IssueLinkingHandler issueLinkingHandler;
    Long id;
    boolean confirm;
    private IssueLinkType linkType;
    private Collection<IssueLink> links;
    private Long swapLinkTypeId;
    String action = "swap";

    public DeleteLinkType(IssueLinkTypeManager issueLinkTypeManager, IssueLinkTypeDestroyer issueLinkTypeDestroyer, IssueLinkManager issueLinkManager, IssueLinkingHandler issueLinkingHandler) {
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkTypeDestroyer = issueLinkTypeDestroyer;
        this.issueLinkManager = issueLinkManager;
        this.issueLinkingHandler = issueLinkingHandler;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.getLinkType() == null) {
            this.addErrorMessage(this.getText("admin.errors.linking.link.type.not.found", this.id));
        }
        if (this.action.equalsIgnoreCase("swap") && this.swapLinkTypeId.equals(this.id)) {
            this.addError("swapLinkTypeId", this.getText("admin.errors.linking.move.links.to.link.type.being.deleted"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.confirm) {
            IssueLinkType swapLinkType = null;
            if (this.action.equalsIgnoreCase("swap")) {
                swapLinkType = this.issueLinkTypeManager.getIssueLinkType(this.swapLinkTypeId);
            }
            this.issueLinkTypeDestroyer.removeIssueLinkType(this.getId(), swapLinkType, this.getLoggedInUser());
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        this.issueLinkingHandler.handleIssueLinkTypeRemove(this.linkType);
        return this.getRedirect("ViewLinkTypes!default.jspa");
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public IssueLinkType getLinkType() {
        if (this.linkType == null) {
            this.linkType = this.issueLinkTypeManager.getIssueLinkType(this.id);
        }
        return this.linkType;
    }

    public Collection getLinks() {
        if (this.links == null) {
            this.links = this.issueLinkManager.getIssueLinks(this.getId());
            if (this.links == null) {
                this.links = Collections.emptyList();
            }
        }
        return this.links;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public Long getSwapLinkTypeId() {
        return this.swapLinkTypeId;
    }

    public void setSwapLinkTypeId(Long swapLinkTypeId) {
        this.swapLinkTypeId = swapLinkTypeId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Collection getOtherLinkTypes() {
        ArrayList otherTypes = Lists.newArrayList();
        Collection linkTypes = this.issueLinkTypeManager.getIssueLinkTypes();
        for (IssueLinkType linkType : linkTypes) {
            if (linkType.equals(this.getLinkType())) continue;
            otherTypes.add(linkType);
        }
        return otherTypes;
    }
}

