/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.priority.PrioritySchemeMapping;
import com.atlassian.jira.issue.priority.PrioritySchemeMigrateRequestHelper;
import com.atlassian.jira.issue.priority.PrioritySchemeMigrator;
import com.atlassian.jira.issue.priority.PrioritySchemeMigratorFinder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;

@WebSudoRequired
public class MigratePrioritySchemeAction
extends JiraWebActionSupport {
    private final PageBuilderService pageBuilder;
    private final PrioritySchemeMigrator prioritySchemeMigrator;
    private final PrioritySchemeMigratorFinder prioritySchemeMigratorFinder;
    private final PrioritySchemeManager prioritySchemeManager;
    private final TaskManager taskManager;
    private final PrioritySchemeMigrateRequestHelper prioritySchemeMigrateRequestHelper;
    private Collection<Long> projects;
    private Long targetSchemeId;
    private boolean editingScheme;
    private FieldConfigScheme targetScheme;
    private List<Priority> availablePriorities = ImmutableList.of();
    private Collection<SchemeMigrationForm> migrationForms;

    public MigratePrioritySchemeAction(PageBuilderService pageBuilder, PrioritySchemeMigrator prioritySchemeMigrator, PrioritySchemeMigratorFinder prioritySchemeMigratorFinder, PrioritySchemeManager prioritySchemeManager, TaskManager taskManager, PrioritySchemeMigrateRequestHelper prioritySchemeMigrateRequestHelper) {
        this.pageBuilder = pageBuilder;
        this.prioritySchemeMigrator = prioritySchemeMigrator;
        this.prioritySchemeMigratorFinder = prioritySchemeMigratorFinder;
        this.prioritySchemeManager = prioritySchemeManager;
        this.taskManager = taskManager;
        this.prioritySchemeMigrateRequestHelper = prioritySchemeMigrateRequestHelper;
    }

    private Optional<String> initOrRedirect() {
        this.pageBuilder.assembler().resources().requireWebResource("jira.webresources:migrate-priority-scheme");
        Optional<PrioritySchemeMigrateRequestHelper.MigratePrioritySchemeRequest> migrateRequest = this.prioritySchemeMigrateRequestHelper.getMigratePrioritySchemeRequest();
        if (!migrateRequest.isPresent()) {
            this.log.error((Object)"MigratePrioritySchemeRequest was not set before entering MigratePriorityScheme.jspa. A user might have tried to access the page directly. It should be only accessed by redirection.");
            return Optional.of(this.getRedirect("ViewPrioritySchemes.jspa"));
        }
        this.projects = migrateRequest.get().projects;
        this.targetSchemeId = migrateRequest.get().targetSchemeId;
        this.editingScheme = migrateRequest.get().isEditingScheme;
        this.targetScheme = this.prioritySchemeManager.getScheme(this.targetSchemeId);
        this.migrationForms = this.createMigrationForm(this.targetScheme, this.projects.stream().map(id -> this.getProjectManager().getProjectObj(id)).collect(Collectors.toList()));
        this.availablePriorities = this.prioritiesInScheme(this.targetScheme);
        return Optional.empty();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        return this.initOrRedirect().orElse("input");
    }

    @SupportedMethods(value={RequestMethod.POST})
    public String doExecute() {
        Optional<String> initResult = this.initOrRedirect();
        if (initResult.isPresent()) {
            return initResult.get();
        }
        if (this.migrationForms.stream().anyMatch(MigratePrioritySchemeAction.not(SchemeMigrationForm::hasAllFieldsPopulated))) {
            this.pageBuilder.assembler().resources().requireWebResource("jira.webresources:migrate-priority-scheme");
            this.addErrorMessage(this.getText("admin.schemes.priority.associate.missing.field.error"));
            return "input";
        }
        PrioritySchemeMapping mapping = this.createSchemeMapping(this.targetScheme, this.migrationForms, this.projects.stream().map(id -> this.getProjectManager().getProjectObj(id)).collect(Collectors.toList()));
        this.prioritySchemeMigrateRequestHelper.clearMigratePrioritySchemeRequest();
        TaskDescriptor<Long> taskDescriptor = this.taskManager.submitTask(new MigrateSchemeTask(mapping), "migrate-priority-scheme", new MigratePrioritySchemeTaskContext(this.editingScheme));
        return this.getRedirect(taskDescriptor.getProgressURL());
    }

    private static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    private PrioritySchemeMapping createSchemeMapping(FieldConfigScheme targetScheme, Iterable<SchemeMigrationForm> forms, Collection<Project> projects) {
        PrioritySchemeMapping mapping = new PrioritySchemeMapping(targetScheme);
        mapping.addAffectedProjects(projects);
        for (SchemeMigrationForm schemeForm : forms) {
            for (PriorityMappingForm priorityForm : schemeForm.getPriorityMapping()) {
                mapping.addPriorityMapping(schemeForm.getSourceSchemeId(), priorityForm.getSourcePriority(), this.getConstantsManager().getPriorityObject(priorityForm.getValue()));
            }
        }
        return mapping;
    }

    private Set<SchemeMigrationForm> createMigrationForm(FieldConfigScheme targetScheme, Iterable<Project> projects) {
        HashMultimap affectedSchemes = HashMultimap.create();
        HashMultimap affectedProjects = HashMultimap.create();
        HashMultimap schemeToProject = HashMultimap.create();
        for (Project project : projects) {
            Set<Priority> unmappedPriorities = this.prioritySchemeMigratorFinder.findUnmappedPriorities(project, targetScheme);
            FieldConfigScheme scheme = this.prioritySchemeManager.getScheme(project);
            affectedProjects.putAll((Object)project, unmappedPriorities);
            affectedSchemes.putAll((Object)scheme, unmappedPriorities);
            schemeToProject.put((Object)scheme, (Object)project);
        }
        Map<String, String> inputParameters = MigratePrioritySchemeAction.getInputParameters();
        return affectedSchemes.keySet().stream().filter(arg_0 -> MigratePrioritySchemeAction.lambda$createMigrationForm$2((SetMultimap)affectedSchemes, arg_0)).map(arg_0 -> MigratePrioritySchemeAction.lambda$createMigrationForm$3(targetScheme, (SetMultimap)schemeToProject, (SetMultimap)affectedSchemes, inputParameters, arg_0)).collect(Collectors.toSet());
    }

    private static Map<String, String> getInputParameters() {
        Map parameters = ActionContext.getParameters();
        return parameters.entrySet().stream().filter(entry -> ((String[])entry.getValue()).length > 0).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((String[])entry.getValue())[0]));
    }

    @ActionViewData(key="projects")
    public Collection<Long> getProjects() {
        return this.projects;
    }

    @ActionViewData(key="targetSchemeId")
    public Long getTargetSchemeId() {
        return this.targetSchemeId;
    }

    @ActionViewData(key="availablePriorities")
    public List<Priority> getAvailablePriorities() {
        return this.availablePriorities;
    }

    @ActionViewData(key="migrationForms")
    public Collection<SchemeMigrationForm> getMigrationForms() {
        return this.migrationForms;
    }

    @ActionViewData(key="xsrfToken")
    public String getXsrfToken() {
        return super.getXsrfToken();
    }

    @ActionViewData(key="errorMessages")
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }

    @ActionViewData(key="editingScheme")
    public boolean isEditingScheme() {
        return this.editingScheme;
    }

    public void setEditingScheme(boolean editingScheme) {
        this.editingScheme = editingScheme;
    }

    private List<Priority> prioritiesInScheme(FieldConfigScheme scheme) {
        return ImmutableList.copyOf((Collection)this.prioritySchemeManager.getPrioritiesFromIds((Collection)this.prioritySchemeManager.getOptions(this.prioritySchemeManager.getFieldConfigForDefaultMapping(scheme))));
    }

    private static /* synthetic */ SchemeMigrationForm lambda$createMigrationForm$3(FieldConfigScheme targetScheme, SetMultimap schemeToProject, SetMultimap affectedSchemes, Map inputParameters, FieldConfigScheme sourceScheme) {
        return SchemeMigrationForm.create(sourceScheme, targetScheme, schemeToProject.get((Object)sourceScheme), affectedSchemes.get((Object)sourceScheme), inputParameters);
    }

    private static /* synthetic */ boolean lambda$createMigrationForm$2(SetMultimap affectedSchemes, FieldConfigScheme sourceScheme) {
        return !affectedSchemes.get((Object)sourceScheme).isEmpty();
    }

    public static class PriorityMappingForm {
        private final Priority sourcePriority;
        private final String targetPriorityFieldId;
        private final String value;

        PriorityMappingForm(Priority sourcePriority, String targetPriorityFieldId, String value) {
            this.sourcePriority = sourcePriority;
            this.targetPriorityFieldId = targetPriorityFieldId;
            this.value = value;
        }

        static PriorityMappingForm mapPriorityToScheme(Priority priority, FieldConfigScheme targetScheme) {
            return PriorityMappingForm.mapPriorityToScheme(priority, targetScheme, (Map<String, String>)ImmutableMap.of());
        }

        static PriorityMappingForm mapPriorityToScheme(Priority priority, FieldConfigScheme targetScheme, Map<String, String> inputParameters) {
            String fieldId = String.format("scheme%d_priority%s", targetScheme.getId(), priority.getId());
            String value = inputParameters.getOrDefault(fieldId, "");
            return new PriorityMappingForm(priority, fieldId, value);
        }

        public Priority getSourcePriority() {
            return this.sourcePriority;
        }

        public String getTargetPriorityFieldId() {
            return this.targetPriorityFieldId;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isPopulated() {
            return !StringUtils.isBlank((CharSequence)this.value);
        }
    }

    public static class SchemeMigrationForm {
        private final long sourceSchemeId;
        private final String sourceSchemeName;
        private final long targetSchemeId;
        private final String targetSchemeName;
        private final Set<String> affectedProjects;
        private final List<PriorityMappingForm> priorityMapping;

        private SchemeMigrationForm(long sourceSchemeId, String sourceSchemeName, long targetSchemeId, String targetSchemeName, Set<String> affectedProjects, List<PriorityMappingForm> priorityMapping) {
            this.sourceSchemeId = sourceSchemeId;
            this.sourceSchemeName = sourceSchemeName;
            this.targetSchemeId = targetSchemeId;
            this.targetSchemeName = targetSchemeName;
            this.affectedProjects = affectedProjects;
            this.priorityMapping = priorityMapping;
        }

        public long getSourceSchemeId() {
            return this.sourceSchemeId;
        }

        public String getSourceSchemeName() {
            return this.sourceSchemeName;
        }

        public long getTargetSchemeId() {
            return this.targetSchemeId;
        }

        public String getTargetSchemeName() {
            return this.targetSchemeName;
        }

        public Set<String> getAffectedProjects() {
            return this.affectedProjects;
        }

        public List<PriorityMappingForm> getPriorityMapping() {
            return this.priorityMapping;
        }

        public static SchemeMigrationForm create(FieldConfigScheme sourceScheme, FieldConfigScheme targetScheme, Collection<Project> affectedProjects, Collection<Priority> priorityList) {
            return SchemeMigrationForm.create(sourceScheme, targetScheme, affectedProjects, priorityList, (Map<String, String>)ImmutableMap.of());
        }

        public static SchemeMigrationForm create(FieldConfigScheme sourceScheme, FieldConfigScheme targetScheme, Collection<Project> affectedProjects, Collection<Priority> priorityList, Map<String, String> inputParameters) {
            return new SchemeMigrationForm(sourceScheme.getId(), sourceScheme.getName(), targetScheme.getId(), targetScheme.getName(), affectedProjects.stream().map(Project::getName).collect(Collectors.toSet()), priorityList.stream().map(p -> PriorityMappingForm.mapPriorityToScheme(p, sourceScheme, inputParameters)).collect(Collectors.toList()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemeMigrationForm that = (SchemeMigrationForm)o;
            return this.sourceSchemeId == that.sourceSchemeId && this.targetSchemeId == that.targetSchemeId;
        }

        public int hashCode() {
            return Objects.hash(this.sourceSchemeId, this.targetSchemeId);
        }

        public boolean isValid() {
            return this.sourceSchemeId != this.targetSchemeId;
        }

        public boolean hasAllFieldsPopulated() {
            return this.priorityMapping.stream().allMatch(PriorityMappingForm::isPopulated);
        }
    }

    public static class MigratePrioritySchemeTaskContext
    implements TaskContext {
        final boolean editScheme;

        public MigratePrioritySchemeTaskContext(boolean editScheme) {
            this.editScheme = editScheme;
        }

        @Override
        public String buildProgressURL(Long taskId) {
            String postfix = this.editScheme ? "&editingScheme=true" : "";
            return "/secure/project/MigratePrioritySchemeProgress.jspa?&taskId=" + taskId + postfix;
        }
    }

    public class MigrateSchemeTask
    implements Callable<Long>,
    ProvidesTaskProgress {
        private final PrioritySchemeMapping mapping;
        private TaskProgressSink taskProgressSink = TaskProgressSink.NULL_SINK;

        public MigrateSchemeTask(PrioritySchemeMapping mapping) {
            this.mapping = mapping;
        }

        @Override
        public Long call() throws Exception {
            ServiceOutcome<Long> result = MigratePrioritySchemeAction.this.prioritySchemeMigrator.migrate(this.mapping, MigratePrioritySchemeAction.this.getLoggedInUser(), this.taskProgressSink);
            Preconditions.checkState((boolean)result.isValid());
            return (Long)result.get();
        }

        @Override
        public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
            this.taskProgressSink = taskProgressSink;
        }
    }
}

