/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.roles;

import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.admin.roles.AbstractRoleActors;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;

@WebSudoRequired
public class ViewProjectRoles
extends AbstractRoleActors {
    private String name;
    private String description;

    public ViewProjectRoles(ProjectRoleService projectRoleService, PluginAccessor pluginAccessor) {
        super(projectRoleService, pluginAccessor);
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doAddRole() throws Exception {
        this.validateName();
        if (this.invalidInput()) {
            return "error";
        }
        this.projectRoleService.createProjectRole((ProjectRole)new ProjectRoleImpl(this.name, this.description), (ErrorCollection)this);
        if (this.hasAnyErrors()) {
            return "error";
        }
        return this.getRedirect("ViewProjectRoles.jspa");
    }

    protected void validateName() {
        if (!TextUtils.stringSet((String)this.name)) {
            this.addError("name", this.getText("admin.errors.must.specify.a.name.for.the.to.be.added", "role"));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

