/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.trustedapps;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.auth.trustedapps.KeyFactory;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationBuilder;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationService;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationSyntacticValidator;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.security.auth.trustedapps.Application;
import com.atlassian.security.auth.trustedapps.ApplicationRetriever;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
public class ViewTrustedApplications
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger(ViewTrustedApplications.class);
    final TrustedApplicationSyntacticValidator validator = new TrustedApplicationSyntacticValidator();
    private final TrustedApplicationService service;
    private final ApplicationProperties properties;
    private String trustedAppBaseUrl;

    public ViewTrustedApplications(TrustedApplicationService service, ApplicationProperties properties) {
        this.service = service;
        this.properties = properties;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() {
        return this.getResult();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        return this.getResult();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doRequest() {
        TrustedApplicationBuilder builder;
        if (this.trustedAppBaseUrl != null) {
            this.trustedAppBaseUrl = this.trustedAppBaseUrl.trim();
        }
        if (!this.validator.validate(this.getJiraServiceContext(), (I18nHelper)this, this.trustedAppBaseUrl)) {
            return "error";
        }
        ErrorCollection errorCollection = this.getJiraServiceContext().getErrorCollection();
        try {
            builder = this.requestTrustedApplication(this.trustedAppBaseUrl);
            if (!builder.toInfo().isValidKey()) {
                this.getJiraServiceContext().getErrorCollection().addError("trustedAppBaseUrl", this.getText("admin.trustedapps.request.error.bad.key", builder.toInfo().getPublicKey()));
                KeyFactory.InvalidPublicKey key = (KeyFactory.InvalidPublicKey)builder.toInfo().getPublicKey();
                log.warn("InvalidKey: " + key, (Throwable)key.getCause());
                return "error";
            }
        }
        catch (ApplicationRetriever.RemoteSystemNotFoundException e) {
            errorCollection.addError("trustedAppBaseUrl", this.getText("admin.trustedapps.request.error.unknownhost", this.trustedAppBaseUrl));
            log.warn(e.getMessage(), (Throwable)e);
            return "error";
        }
        catch (ApplicationRetriever.RetrievalException e) {
            errorCollection.addError("trustedAppBaseUrl", this.getText("admin.trustedapps.request.error.filenotfound", this.trustedAppBaseUrl));
            log.warn(e.getMessage(), (Throwable)e);
            return "error";
        }
        catch (FileNotFoundException e) {
            errorCollection.addError("trustedAppBaseUrl", this.getText("admin.trustedapps.request.error.filenotfound", this.trustedAppBaseUrl));
            log.warn(e.getMessage(), (Throwable)e);
            return "error";
        }
        catch (UnknownHostException e) {
            errorCollection.addError("trustedAppBaseUrl", this.getText("admin.trustedapps.request.error.unknownhost", this.trustedAppBaseUrl));
            log.warn(e.getMessage(), (Throwable)e);
            return "error";
        }
        catch (IOException e) {
            errorCollection.addError("trustedAppBaseUrl", this.getText("admin.trustedapps.request.error.unknown", this.trustedAppBaseUrl, e.toString()));
            log.warn(e.getMessage(), (Throwable)e);
            return "error";
        }
        return this.getRedirect("EditTrustedApplication!request.jspa?" + builder.toQueryString());
    }

    private TrustedApplicationBuilder requestTrustedApplication(String url) throws IOException, ApplicationRetriever.RetrievalException {
        TrustedApplicationBuilder builder = new TrustedApplicationBuilder();
        builder.setName(url);
        builder.setApplicationId("");
        try {
            InetAddress address = InetAddress.getByName(new URI(url).getHost());
            builder.setIpMatch(address.getHostAddress());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Application application = KeyFactory.getEncryptionProvider().getApplicationCertificate(url);
        builder.setApplicationId(application.getID());
        builder.setPublicKey(application.getPublicKey());
        builder.setUrlMatch(this.properties.getDefaultBackedString("jira.trustedapps.urlmatch.default"));
        int defaultTimeout = 10000;
        try {
            defaultTimeout = Integer.valueOf(this.properties.getDefaultBackedString("jira.trustedapps.timeout.default"));
        }
        catch (NumberFormatException e) {
            log.warn("Could not set a default timeout due to exception!", (Throwable)e);
        }
        builder.setTimeout(defaultTimeout);
        return builder;
    }

    public Collection getTrustedApplications() {
        return this.service.getAll(this.getJiraServiceContext());
    }

    public String getTrustedAppBaseUrl() {
        return this.trustedAppBaseUrl;
    }

    public void setTrustedAppBaseUrl(String trustedAppBaseUrl) {
        this.trustedAppBaseUrl = trustedAppBaseUrl;
    }

    final class Fields {
        static final String BASE_URL = "trustedAppBaseUrl";

        private Fields() {
        }
    }
}

