/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.core.util.StringUtils;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.filter.SearchRequestAdminService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.userformat.UserFormatter;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.util.GroupToIssueSecuritySchemeMapper;
import com.atlassian.jira.security.util.GroupToNotificationSchemeMapper;
import com.atlassian.jira.security.util.GroupToPermissionSchemeMapper;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Collections;

@WebSudoRequired
public class ViewGroup
extends JiraWebActionSupport {
    private String name;
    private Group group;
    private GroupToPermissionSchemeMapper groupPermissionSchemeMapper;
    private GroupToNotificationSchemeMapper groupNotificationSchemeMapper;
    private GroupToIssueSecuritySchemeMapper groupIssueSecuritySchemeMapper;
    private final SearchRequestAdminService searchRequestAdminService;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final UserFormatter fullNameUserFormatter;
    private CrowdService crowdService;

    public ViewGroup(SearchRequestAdminService searchRequestAdminService, UserFormats userFormats, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, PermissionSchemeManager permissionSchemeManager, PermissionManager permissionManager, NotificationSchemeManager notificationSchemeManager, CrowdService crowdService) {
        this.searchRequestAdminService = searchRequestAdminService;
        this.fullNameUserFormatter = userFormats.formatter("fullName");
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.crowdService = crowdService;
        this.groupPermissionSchemeMapper = new GroupToPermissionSchemeMapper(permissionSchemeManager, permissionManager);
        this.groupNotificationSchemeMapper = new GroupToNotificationSchemeMapper(notificationSchemeManager);
        IssueSecuritySchemeManager securitySchemeManager = (IssueSecuritySchemeManager)ComponentAccessor.getComponentOfType(IssueSecuritySchemeManager.class);
        this.groupIssueSecuritySchemeMapper = new GroupToIssueSecuritySchemeMapper(securitySchemeManager);
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public String execute() {
        this.group = this.crowdService.getGroup(this.getName());
        if (this.group == null) {
            this.addErrorMessage("Group not found.");
        }
        return this.getResult();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Group getGroup() {
        return this.group;
    }

    public Collection<Scheme> getPermissionSchemes(String groupName) {
        if (this.groupPermissionSchemeMapper != null) {
            return this.groupPermissionSchemeMapper.getMappedValues(groupName);
        }
        return Collections.emptyList();
    }

    public Collection<Scheme> getNotificationSchemes(String groupName) {
        if (this.groupNotificationSchemeMapper != null) {
            return this.groupNotificationSchemeMapper.getMappedValues(groupName);
        }
        return Collections.emptyList();
    }

    public Collection<Scheme> getIssueSecuritySchemes(String groupName) {
        if (this.groupIssueSecuritySchemeMapper != null) {
            return this.groupIssueSecuritySchemeMapper.getMappedValues(groupName);
        }
        return Collections.emptyList();
    }

    public Collection getSavedFilters(Group group) {
        Collection filters = this.searchRequestAdminService.getFiltersSharedWithGroup(group);
        return filters == null ? Collections.emptyList() : filters;
    }

    public String getEscapeAmpersand(String str) {
        return StringUtils.replaceAll((String)str, (String)"&", (String)"%26");
    }

    public boolean isUserAbleToDeleteGroup(String groupName) {
        return this.globalPermissionGroupAssociationUtil.isUserAbleToDeleteGroup(this.getLoggedInUser(), groupName);
    }

    public String getFullUserName(String userName) {
        if (userName != null) {
            return this.fullNameUserFormatter.formatUsername(userName, "view_group");
        }
        return null;
    }
}

