/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowStep;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@WebSudoRequired
public class EditWorkflowStep
extends AbstractWorkflowStep {
    private final StepDescriptor step;
    private Collection statuses;
    private String originatingUrl;

    public EditWorkflowStep(JiraWorkflow workflow, StepDescriptor step, ConstantsManager constantsManager, WorkflowService workflowService) {
        super(workflow, constantsManager, workflowService);
        this.step = step;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.setStepName(this.step.getName());
        this.initStatuses();
        return super.doDefault();
    }

    private void initStatuses() {
        if (this.step.getMetaAttributes() != null && this.step.getMetaAttributes().containsKey("jira.status.id")) {
            this.setStepStatus((String)this.step.getMetaAttributes().get("jira.status.id"));
            this.statuses = new ArrayList();
            this.statuses.add(this.getConstantsManager().getStatus(this.getStepStatus()));
            this.statuses.addAll(this.getUnlinkedStatusesGVs());
        } else {
            this.addErrorMessage(this.getText("admin.errors.no.associated.status"));
        }
    }

    protected void doValidation() {
        StepDescriptor existingStep;
        List existingSteps;
        if (TextUtils.stringSet((String)this.getStepName())) {
            if (!this.getStepName().equals(this.step.getName())) {
                existingSteps = this.getWorkflow().getDescriptor().getSteps();
                for (Object existingStep1 : existingSteps) {
                    existingStep = (StepDescriptor)existingStep1;
                    if (!this.getStepName().equalsIgnoreCase(existingStep.getName())) continue;
                    this.addError("stepName", this.getText("admin.errors.step.with.name.already.exists"));
                }
            }
        } else {
            this.addError("stepName", this.getText("admin.errors.step.name.must.be.specified"));
        }
        if (!this.isOldStepOnDraft(this.step)) {
            if (TextUtils.stringSet((String)this.getStepStatus())) {
                if (!this.getStepStatus().equals(this.step.getMetaAttributes().get("jira.status.id"))) {
                    existingSteps = this.getWorkflow().getDescriptor().getSteps();
                    for (Object existingStep1 : existingSteps) {
                        existingStep = (StepDescriptor)existingStep1;
                        if (!this.getStepStatus().equalsIgnoreCase((String)existingStep.getMetaAttributes().get("jira.status.id"))) continue;
                        this.addError("stepStatus", this.getText("admin.errors.existing.step.already.linked"));
                    }
                }
            } else {
                this.addError("stepStatus", this.getText("admin.errors.step.must.be.linked.to.status"));
            }
        } else if (this.getStepStatus() != null && !this.getStepStatus().equals(this.step.getMetaAttributes().get("jira.status.id"))) {
            this.addError("stepStatus", this.getText("admin.errors.step.edit.draft.status"));
        }
        if (this.invalidInput()) {
            this.initStatuses();
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        StepDescriptor stepDescriptor = this.getWorkflow().getDescriptor().getStep(this.step.getId());
        stepDescriptor.setName(this.getStepName());
        if (!this.isOldStepOnDraft(this.step)) {
            stepDescriptor.getMetaAttributes().put("jira.status.id", this.getStepStatus());
        }
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.getRedirect(this.getCancelUrl());
    }

    public StepDescriptor getStep() {
        return this.step;
    }

    public Collection getStatuses() {
        return this.statuses;
    }

    public String getOriginatingUrl() {
        return this.originatingUrl;
    }

    public void setOriginatingUrl(String originatingUrl) {
        this.originatingUrl = originatingUrl;
    }

    public String getCancelUrl() {
        if ("viewWorkflowStep".equals(this.getOriginatingUrl())) {
            return "ViewWorkflowStep.jspa" + this.getBasicWorkflowParameters() + "&workflowStep=" + this.step.getId();
        }
        return "ViewWorkflowSteps.jspa" + this.getBasicWorkflowParameters();
    }
}

