/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.AbstractSelectProjectScheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class SelectProjectWorkflowScheme
extends AbstractSelectProjectScheme {
    private final WorkflowSchemeMigrationTaskAccessor taskAccessor;
    private final TaskManager taskManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final TaskDescriptorBean.Factory taskBeanFactory;
    private TaskDescriptorBean<WorkflowMigrationResult> currentActivateTask;
    private List<Project> projects;
    private boolean draftMigration;

    public SelectProjectWorkflowScheme(WorkflowSchemeMigrationTaskAccessor taskAccessor, TaskManager taskManager, WorkflowSchemeManager workflowSchemeManager, TaskDescriptorBean.Factory taskBeanFactory) {
        this.workflowSchemeManager = workflowSchemeManager;
        this.taskBeanFactory = taskBeanFactory;
        this.taskAccessor = taskAccessor;
        this.taskManager = taskManager;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (this.hasPermission()) {
            return super.doDefault();
        }
        return "securitybreach";
    }

    @Override
    protected void doValidation() {
    }

    @Override
    public SchemeManager getSchemeManager() {
        return this.workflowSchemeManager;
    }

    public WorkflowSchemeManager getWorkflowSchemeManager() {
        return this.workflowSchemeManager;
    }

    @Override
    public String getProjectReturnUrl() {
        return "/plugins/servlet/project-config/" + this.getProject().getKey() + "/workflows";
    }

    public String getReturnUrlForCancelLink() {
        String url;
        if (this.getProject() != null) {
            url = this.getProjectReturnUrl();
        } else {
            Long schemeId = this.getWorkflowSchemeManager().getWorkflowSchemeObj((Project)Iterables.getFirst(this.getProjects(), (Object)this.getProject())).getId();
            url = "/secure/admin/EditWorkflowScheme.jspa?schemeId=" + schemeId;
        }
        return url;
    }

    @Override
    public String getRedirectURL() {
        String url = this.getReturnUrlForCancelLink();
        if (this.isDraftMigration()) {
            url = url + "#draftMigrationSuccess";
        }
        return url;
    }

    TaskManager getTaskManager() {
        return this.taskManager;
    }

    public boolean isAnyLiveTasks() {
        return !this.taskManager.getLiveTasks().isEmpty();
    }

    void initTaskDescriptorBean(TaskDescriptor<WorkflowMigrationResult> taskDescriptor) {
        this.currentActivateTask = this.taskBeanFactory.create(taskDescriptor);
    }

    TaskDescriptorBean<WorkflowMigrationResult> getCurrentTask(boolean searchForTask) {
        if (this.currentActivateTask == null && searchForTask) {
            TaskDescriptor<WorkflowMigrationResult> taskDescriptor = null;
            if (this.isDraftMigration()) {
                DraftWorkflowScheme draft = this.workflowSchemeManager.getDraft(this.getSchemeId().longValue());
                if (draft != null) {
                    taskDescriptor = this.taskAccessor.getActiveByProjects(draft, false);
                }
            } else {
                AssignableWorkflowScheme targetScheme;
                DraftWorkflowScheme draft;
                Project projectObject = this.getProject();
                if (projectObject != null) {
                    taskDescriptor = this.taskAccessor.getActive(projectObject);
                }
                if (taskDescriptor == null && (draft = this.workflowSchemeManager.getDraftForParent(targetScheme = this.getSchemeId() == null ? this.workflowSchemeManager.getDefaultWorkflowScheme() : this.workflowSchemeManager.getWorkflowSchemeObj(this.getSchemeId().longValue()))) != null) {
                    taskDescriptor = this.taskAccessor.getActive((WorkflowScheme)draft);
                }
            }
            if (taskDescriptor != null) {
                this.initTaskDescriptorBean(taskDescriptor);
            }
        }
        return this.currentActivateTask;
    }

    public TaskDescriptorBean getCurrentTask() {
        return this.getCurrentTask(true);
    }

    public boolean isDraftMigration() {
        return this.draftMigration;
    }

    public void setDraftMigration(boolean draftMigration) {
        this.draftMigration = draftMigration;
    }

    AssignableWorkflowScheme getExistingScheme() {
        if (this.isDraftMigration()) {
            return this.workflowSchemeManager.getParentForDraft(this.getSchemeId().longValue());
        }
        return this.workflowSchemeManager.getWorkflowSchemeObj(this.getProject());
    }

    public List<Project> getProjects() {
        return this.projects != null ? this.projects : Collections.emptyList();
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public String getProjectIdsParameter() {
        return SelectProjectWorkflowScheme.getProjectIdsParameter(this.getProjects());
    }

    List<Long> getProjectIds() {
        return SelectProjectWorkflowScheme.getProjectIds(this.getProjects());
    }

    public static List<Long> getProjectIds(List<Project> projects) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(projects, Project::getId));
    }

    private static List<String> getProjectIdStrings(List<Project> projects) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(SelectProjectWorkflowScheme.getProjectIds(projects), (Function)Functions.toStringFunction()));
    }

    public static String getProjectIdsParameter(List<Project> projects) {
        return StringUtils.join(SelectProjectWorkflowScheme.getProjectIdStrings(projects), (String)",");
    }

    public void setProjectIdsParameter(String projectIdsStr) {
        List<String> projectIds = Arrays.asList(projectIdsStr.split(","));
        Iterable projects = Iterables.transform(projectIds, projectId -> this.getProjectManager().getProjectObj(Long.valueOf(projectId)));
        this.setProjects((List<Project>)ImmutableList.copyOf((Iterable)projects));
    }
}

