/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentMonitorStore;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachment;
import com.atlassian.jira.util.ExceptionUtil;
import com.atlassian.jira.web.action.issue.TemporaryWebAttachmentsMonitor;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultTemporaryWebAttachmentsMonitor
implements TemporaryWebAttachmentsMonitor,
Startable {
    private static final Logger log = LoggerFactory.getLogger(DefaultTemporaryWebAttachmentsMonitor.class);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)DefaultTemporaryWebAttachmentsMonitor.class.getName());
    private static final JobId JOB_ID = JobId.of((String)DefaultTemporaryWebAttachmentsMonitor.class.getName());
    private static final long EVERY_HOUR = TimeUnit.HOURS.toMillis(1L);
    private final StreamAttachmentStore attachmentStore;
    private final TemporaryAttachmentMonitorStore temporaryAttachmentMonitorStore;
    private final SchedulerService schedulerService;

    public DefaultTemporaryWebAttachmentsMonitor(StreamAttachmentStore attachmentStore, TemporaryAttachmentMonitorStore temporaryAttachmentMonitorStore, SchedulerService schedulerService) {
        this.attachmentStore = attachmentStore;
        this.temporaryAttachmentMonitorStore = temporaryAttachmentMonitorStore;
        this.schedulerService = schedulerService;
    }

    public void start() throws Exception {
        this.scheduleCleanup();
    }

    private void scheduleCleanup() {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, this.periodicallyRemoveTempAttachmentRows());
        Date oneHourFromNow = new DateTime().plusHours(1).toDate();
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)EVERY_HOUR, (Date)oneHourFromNow));
        try {
            this.schedulerService.scheduleJob(JOB_ID, config);
        }
        catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private JobRunner periodicallyRemoveTempAttachmentRows() {
        return new JobRunner(){

            public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
                try {
                    DateTime oneWeekOld = new DateTime().minusDays(7);
                    log.debug(String.format("Removing all temporary attachments older than '%s'", oneWeekOld));
                    long howMany = DefaultTemporaryWebAttachmentsMonitor.this.temporaryAttachmentMonitorStore.removeOlderThan(oneWeekOld);
                    return JobRunnerResponse.success((String)String.format("Removed %d temporary attachments", howMany));
                }
                catch (Exception e) {
                    log.error("Unable to remove older temporary attachment rows", (Throwable)e);
                    return JobRunnerResponse.failed((Throwable)e);
                }
            }
        };
    }

    @Override
    public Option<TemporaryWebAttachment> getById(String temporaryAttachmentId) {
        return this.temporaryAttachmentMonitorStore.getById(TemporaryAttachmentId.fromString((String)temporaryAttachmentId));
    }

    @Override
    public Option<TemporaryWebAttachment> removeById(String temporaryAttachmentId) {
        return this.temporaryAttachmentMonitorStore.removeById(TemporaryAttachmentId.fromString((String)temporaryAttachmentId));
    }

    @Override
    public void add(TemporaryWebAttachment temporaryAttachment) {
        Preconditions.checkNotNull((Object)temporaryAttachment, (Object)"temporaryAttachment");
        if (this.temporaryAttachmentMonitorStore.putIfAbsent(temporaryAttachment)) {
            throw new IllegalArgumentException(String.format("Temporary attachment with id='%s' already in monitor", temporaryAttachment.getStringId()));
        }
    }

    @Override
    public Collection<TemporaryWebAttachment> getByFormToken(String formToken) {
        Preconditions.checkNotNull((Object)formToken);
        return this.temporaryAttachmentMonitorStore.getByFormToken(formToken);
    }

    @Override
    public void cleanByFormToken(String formToken) {
        Preconditions.checkNotNull((Object)formToken);
        this.temporaryAttachmentMonitorStore.getByFormToken(formToken).forEach(twa -> {
            TemporaryAttachmentId temporaryAttachmentId = twa.getTemporaryAttachmentId();
            this.safelyRemoveTemporaryAttachmentFromStore(temporaryAttachmentId);
            this.temporaryAttachmentMonitorStore.removeById(temporaryAttachmentId);
        });
    }

    private void safelyRemoveTemporaryAttachmentFromStore(TemporaryAttachmentId temporaryAttachmentId) {
        this.attachmentStore.deleteTemporaryAttachment(temporaryAttachmentId).fail(throwable -> ExceptionUtil.logExceptionWithWarn(log, "Got exception while removing temporary attachment.", throwable));
        this.temporaryAttachmentMonitorStore.removeById(temporaryAttachmentId);
    }
}

