/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.issue.AbstractViewIssue;
import com.opensymphony.util.TextUtils;

public class DeleteIssue
extends AbstractViewIssue {
    boolean confirm;
    private Integer numberOfSubTasks;
    private final IssueService issueService;
    private IssueService.DeleteValidationResult issueValidationResult;

    public DeleteIssue(SubTaskManager subTaskManager, IssueService issueService) {
        super(subTaskManager);
        this.issueService = issueService;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        ErrorCollection errors;
        if (this.confirm && (errors = this.issueService.delete(this.getLoggedInUser(), this.issueValidationResult)).hasAnyErrors()) {
            this.addErrorCollection(errors);
        }
        return this.returnComplete(this.getViewUrl());
    }

    private boolean isCurrentDeletedIssue(String returnUrl) {
        String key = this.getIssueObject().getKey();
        return returnUrl.endsWith("browse/" + key) || returnUrl.contains("browse/" + key + "?");
    }

    @Override
    public String getViewUrl() {
        String returnUrl = this.getReturnUrl();
        if (TextUtils.stringSet((String)returnUrl) && !this.isCurrentDeletedIssue(returnUrl)) {
            return returnUrl;
        }
        if (TextUtils.stringSet((String)this.getViewIssueKey())) {
            return "/browse/" + this.getViewIssueKey();
        }
        return "/issues/";
    }

    public String getTargetUrl() {
        return this.getViewUrl();
    }

    protected void doValidation() {
        this.issueValidationResult = this.issueService.validateDelete(this.getLoggedInUser(), this.getIssueObject().getId());
        if (!this.issueValidationResult.isValid()) {
            this.addErrorCollection(this.issueValidationResult.getErrorCollection());
        }
    }

    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    public String doDefault() throws Exception {
        IssueService.IssueResult issueResult = this.issueService.getIssue(this.getLoggedInUser(), this.getId());
        this.addErrorCollection(issueResult.getErrorCollection());
        return "input";
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public int getNumberOfSubTasks() {
        if (this.numberOfSubTasks == null) {
            this.numberOfSubTasks = this.getSubTaskManager().getSubTaskIssueLinks(this.getIssueObject().getId()).size();
        }
        return this.numberOfSubTasks;
    }
}

