/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstantImpl;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.AbstractCommentableAssignableIssue;
import com.atlassian.jira.web.bean.MoveIssueBean;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

public class MoveIssue
extends AbstractCommentableAssignableIssue {
    public static final String SUBTASK_STATUS_PREFIX = "subtaskstatus_";
    private static final String SUBTASK_ISSUETYPE_PREFIX = "subtaskissuetype_";
    protected final ConstantsManager constantsManager;
    protected final WorkflowManager workflowManager;
    protected final FieldManager fieldManager;
    protected final FieldLayoutManager fieldLayoutManager;
    protected final IssueFactory issueFactory;

    public MoveIssue(SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService, UserUtil userUtil, UserManager userManager) {
        super(subTaskManager, fieldScreenRendererFactory, commentService, userUtil, userManager);
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
        this.fieldManager = fieldManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueFactory = issueFactory;
    }

    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        if (this.isHasSubTasks()) {
            this.getMoveIssueBean().addAvailablePreviousStep(1);
            return this.forceRedirect("MoveIssueSubtasks!default.jspa?id=" + this.id);
        }
        return this.forceRedirect("MoveIssueUpdateWorkflow!default.jspa?id=" + this.id + "&assignee=" + URLEncoder.encode("" + this.getAssignee(), "UTF8"));
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    public String doDefault() throws Exception {
        try {
            if (!this.hasIssuePermission(ProjectPermissions.MOVE_ISSUES, this.getIssueObject())) {
                return "securitybreach";
            }
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        if (this.isHasSubTasks()) {
            return this.forceRedirect("views/bulkedit/BulkMigrateDetails.jspa?singleIssueId=" + this.getIssueObject().getId());
        }
        if (ActionContext.getSingleValueParameters().containsKey("reset") && "true".equals(ActionContext.getSingleValueParameters().get("reset")) && this.getMoveIssueBean() != null) {
            Long selectedPid = this.getMoveIssueBean().getTargetPid();
            String selectedIssueTypeId = this.getMoveIssueBean().getTargetIssueType();
            this.getMoveIssueBean().clearAvailablePreviousSteps();
            this.getMoveIssueBean().reset();
            this.getMoveIssueBean().setIssueId(this.getIssue().getLong("id"));
            this.getMoveIssueBean().setSourceIssueKey(this.getIssueObject().getKey());
            this.getMoveIssueBean().getFieldValuesHolder().put("project", selectedPid);
            this.getMoveIssueBean().getFieldValuesHolder().put("issuetype", selectedIssueTypeId);
        } else {
            MoveIssueBean moveIssueBean = new MoveIssueBean(this.constantsManager, this.projectManager);
            moveIssueBean.setIssueId(this.getIssue().getLong("id"));
            moveIssueBean.setSourceIssueKey(this.getIssueObject().getKey());
            ActionContext.getSession().put("jira.moveissuebean", moveIssueBean);
            MutableIssue issueObject = this.getIssueObject(this.getIssue());
            this.fieldManager.getProjectField().populateFromIssue(this.getMoveIssueBean().getFieldValuesHolder(), (Issue)issueObject);
            this.fieldManager.getIssueTypeField().populateFromIssue(this.getMoveIssueBean().getFieldValuesHolder(), (Issue)issueObject);
        }
        this.getMoveIssueBean().setCurrentStep(1);
        return "input";
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            try {
                if (!this.hasIssuePermission(ProjectPermissions.MOVE_ISSUES, this.getIssueObject())) {
                    this.addErrorMessage(this.getText("move.issue.nopermissions"));
                    return;
                }
                this.fieldManager.getProjectField().populateFromParams(this.getMoveIssueBean().getFieldValuesHolder(), ActionContext.getParameters());
                this.fieldManager.getIssueTypeField().populateFromParams(this.getMoveIssueBean().getFieldValuesHolder(), ActionContext.getParameters());
                Issue issueObject = this.getIssueForValidation();
                this.fieldManager.getProjectField().validateParams((OperationContext)this.getMoveIssueBean(), (ErrorCollection)this, (I18nHelper)this, issueObject, null);
                this.fieldManager.getIssueTypeField().validateParams((OperationContext)this.getMoveIssueBean(), (ErrorCollection)this, (I18nHelper)this, issueObject, null);
                if (this.getIssue().getLong("project").equals(this.getMoveIssueBean().getTargetPid()) && this.getIssue().getString("type").equals(this.getMoveIssueBean().getTargetIssueType())) {
                    this.addErrorMessage(this.getText("move.issue.nochange"));
                }
                if (!this.invalidInput()) {
                    this.validateAttachmentMove();
                    this.validateCreateIssue();
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Exception: " + e), (Throwable)e);
                this.addErrorMessage("An exception occurred: " + e + ".");
            }
        }
    }

    private Issue getIssueForValidation() {
        MutableIssue issueObject = this.getIssueObject(null);
        issueObject.setProjectObject(this.getTargetProjectObj());
        return issueObject;
    }

    protected String redirectToSessionTimeoutPage() {
        ActionContext.getSession().put("jira.session.timeout.message", this.getText("moveissue.session.timeout.message"));
        return this.getRedirect("SessionTimeoutMessage.jspa");
    }

    protected void validateAttachmentMove() {
        Collection attachments = this.getIssueObject().getAttachments();
        if (!this.hasProjectPermission(ProjectPermissions.CREATE_ATTACHMENTS, this.getTargetProjectObj()) && !attachments.isEmpty()) {
            this.addErrorMessage(this.getText("moveissue.create.attachment.permission"));
        }
    }

    protected void validateCreateIssue() throws GenericEntityException {
        if (!this.hasProjectPermission(ProjectPermissions.CREATE_ISSUES, this.getTargetProjectObj())) {
            this.addErrorMessage(this.getText("moveissue.no.create.permission"));
        }
    }

    public Long getTargetPid() {
        return this.getMoveIssueBean().getTargetPid();
    }

    public String getTargetStatusId() {
        return this.getMoveIssueBean().getTargetStatusId();
    }

    public Project getTargetProjectObj() {
        return this.getProjectManager().getProjectObj(this.getTargetPid());
    }

    public IssueType getTargetIssueTypeObject() {
        return this.constantsManager.getIssueType(this.getTargetIssueType());
    }

    public JiraWorkflow getTargetWorkflow() throws WorkflowException {
        return this.getWorkflowForType(this.getTargetPid(), this.getTargetIssueType());
    }

    public JiraWorkflow getCurrentWorkflow() throws WorkflowException, GenericEntityException {
        return this.getWorkflowForType(this.getProjectObject().getId(), this.getIssue().getString("type"));
    }

    public JiraWorkflow getWorkflowForType(Long projectId, String issueTypeId) throws WorkflowException {
        return this.workflowManager.getWorkflow(projectId, issueTypeId);
    }

    public Status getCurrentStatus() {
        return this.constantsManager.getStatus(this.getIssue().getString("status"));
    }

    public Status getCurrentStatusObject() {
        return this.constantsManager.getStatusObject(this.getIssue().getString("status"));
    }

    public String getTargetIssueType() {
        return this.getMoveIssueBean().getTargetIssueType();
    }

    public String getCurrentIssueType() {
        return this.getIssue().getString("type");
    }

    public Collection getAllowedProjects() {
        return ComponentAccessor.getPermissionManager().getProjects(ProjectPermissions.CREATE_ISSUES, this.getLoggedInUser());
    }

    @Override
    public boolean isSubTask() {
        return this.getSubTaskManager().isSubTask(this.getIssueObject());
    }

    public Collection<Status> getTargetWorkflowStatuses(String issueTypeId) {
        JiraWorkflow workflow = this.getWorkflowForType(this.getTargetPid(), issueTypeId);
        return workflow.getLinkedStatusObjects();
    }

    public boolean isWorkflowMatch(String currentIssueTypeId, String targetIssueTypeId) {
        return this.getWorkflowForType(this.getProjectObject().getId(), currentIssueTypeId).equals(this.getWorkflowForType(this.getTargetPid(), targetIssueTypeId));
    }

    public boolean isHasSubTasks() {
        return this.getSubTaskManager().isSubTasksEnabled() && !this.getSubTaskManager().getSubTaskObjects(this.getIssueObject()).isEmpty();
    }

    public Collection<GenericValue> getSubTasks() {
        Collection issues = this.getSubTaskManager().getSubTaskObjects(this.getIssueObject());
        Stream<GenericValue> x = issues.stream().map(issue -> issue.getGenericValue());
        return x.collect(Collectors.toList());
    }

    public Collection<GenericValue> getSubTaskTypesUsed() {
        Collection<GenericValue> subTasks = this.getSubTasks();
        HashSet<GenericValue> usedSubTaskTypes = new HashSet<GenericValue>();
        for (GenericValue subTask : subTasks) {
            usedSubTaskTypes.add(((IssueConstantImpl)this.constantsManager.getIssueType(subTask.getString("type"))).getGenericValue());
        }
        return usedSubTaskTypes;
    }

    public String getPrefixTaskStatusId(String taskTypeId, String taskStatusId) {
        return SUBTASK_STATUS_PREFIX + taskTypeId + "_" + taskStatusId;
    }

    public String getPrefixIssueTypeId(String issueType) {
        return SUBTASK_ISSUETYPE_PREFIX + issueType;
    }

    public String getSubTaskTargetStatus(String taskTypeId, String taskStatusId) {
        String subTaskTypeKey;
        Map actionParameters = ActionContext.getParameters();
        Object o = actionParameters.get(subTaskTypeKey = SUBTASK_STATUS_PREFIX + taskTypeId + "_" + taskStatusId);
        if (o instanceof String[]) {
            String[] strings = (String[])o;
            return strings[0];
        }
        return null;
    }

    public boolean isStatusChangeRequired() {
        try {
            if (this.isIssueStatusValid()) {
                if (!this.isSubTask() || this.getSubTaskManager().getSubTaskObjects(this.getIssueObject()).isEmpty()) {
                    return this.isTaskStatusChangeRequired();
                }
                return false;
            }
        }
        catch (WorkflowException e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return true;
    }

    public boolean isTaskStatusChangeRequired() throws WorkflowException {
        Collection<GenericValue> types = this.getSubTaskTypesUsed();
        for (GenericValue type : types) {
            if (this.getTaskInvalidStatuses(type.getString("id")).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isIssueStatusValid() throws WorkflowException {
        Status status = this.constantsManager.getStatus(this.getIssue().getString("status"));
        return this.getTargetWorkflow().getLinkedStatusObjects().contains(status);
    }

    public boolean isTaskStatusValid(String typeId, String statusId) throws WorkflowException {
        JiraWorkflow targetWorkflow = this.getWorkflowForType(this.getTargetPid(), typeId);
        Status status = this.constantsManager.getStatus(statusId);
        List availableStatuses = targetWorkflow.getLinkedStatusObjects();
        return availableStatuses.contains(status);
    }

    public Collection<Status> getTaskInvalidStatuses(String typeId) throws WorkflowException {
        Collection<GenericValue> subTasks = this.getSubTasks();
        HashSet invalidStatuses = Sets.newHashSet();
        for (GenericValue subTask : subTasks) {
            Collection<Status> availableStatuses;
            Status status;
            String taskType = subTask.getString("type");
            String taskStatus = subTask.getString("status");
            if (!typeId.equals(taskType) || invalidStatuses.contains(status = this.constantsManager.getStatus(taskStatus)) || (availableStatuses = this.getTargetWorkflowStatuses(taskType)).contains(status)) continue;
            invalidStatuses.add(status);
        }
        return invalidStatuses;
    }

    public Collection getTaskInvalidStatusObjects(String typeId) throws WorkflowException {
        return this.getTaskInvalidStatuses(typeId);
    }

    public Collection getTasksWithStatus(String invalidStatusId) throws WorkflowException {
        Collection subTasks = this.getSubTaskManager().getSubTaskObjects(this.getIssueObject());
        ArrayList tasksWithStatus = Lists.newArrayListWithCapacity((int)subTasks.size());
        for (Issue subTask : subTasks) {
            if (!subTask.getStatusId().equals(invalidStatusId)) continue;
            tasksWithStatus.add(subTask.getGenericValue());
        }
        return tasksWithStatus;
    }

    protected FieldLayoutManager getFieldLayoutManager() {
        return this.fieldLayoutManager;
    }

    public ConstantsManager getConstantsManager() {
        return this.constantsManager;
    }

    protected WorkflowManager getWorkflowManager() {
        return this.workflowManager;
    }

    public MoveIssueBean getMoveIssueBean() {
        return (MoveIssueBean)ActionContext.getSession().get("jira.moveissuebean");
    }

    public void setBeanTargetStatusId(String targetStatusId) {
        if (targetStatusId != null) {
            this.getMoveIssueBean().setTargetStatusId(targetStatusId);
        }
    }

    public String getBeanTargetStatusId() {
        return this.getMoveIssueBean().getTargetStatusId();
    }

    public String getFieldHtml(String fieldId) throws Exception {
        return ((OrderableField)this.fieldManager.getField(fieldId)).getCreateHtml(null, (OperationContext)this.getMoveIssueBean(), (Action)this, (Issue)this.getIssueObject(this.getIssue()), this.getViewHtmlParams());
    }

    protected Map getViewHtmlParams() {
        return EasyMap.build((Object)"noHeader", (Object)Boolean.TRUE);
    }

    public MutableIssue getIssueObject(GenericValue issue) {
        return this.issueFactory.getIssue(issue);
    }

    protected FieldManager getFieldManager() {
        return this.fieldManager;
    }

    public String getSubtaskTargetIssueType(String subtaskIssueType) {
        String issueTypeKey = this.getPrefixIssueTypeId(subtaskIssueType);
        return (String)this.getMoveIssueBean().getFieldValuesHolder().get(issueTypeKey);
    }
}

