/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeyFormatter;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ViewProjects
extends JiraWebActionSupport {
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ProjectTypeManager projectTypeManager;

    public ViewProjects(UserUtil userUtil, UserManager userManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.userUtil = userUtil;
        this.userManager = userManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.projectTypeManager = (ProjectTypeManager)ComponentAccessor.getComponent(ProjectTypeManager.class);
    }

    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        session.removeAttribute("atl.jira.admin.current.project");
        session.removeAttribute("atl.jira.admin.current.project.tab");
        session.removeAttribute("atl.jira.admin.current.project.return.url");
        return super.doExecute();
    }

    public ProjectType getProjectType(ProjectTypeKey projectTypeKey) {
        return (ProjectType)this.projectTypeManager.getByKey(projectTypeKey).getOrElse((Object)this.projectTypeManager.getInaccessibleProjectType());
    }

    public String getFormatedProjectTypeName(ProjectTypeKey projectTypeKey) {
        return ProjectTypeKeyFormatter.format((ProjectTypeKey)projectTypeKey);
    }

    public boolean isAdmin() throws GenericEntityException {
        return ComponentAccessor.getPermissionManager().hasPermission(0, this.getLoggedInUser());
    }

    public boolean isProjectAdmin(GenericValue project) throws GenericEntityException {
        return this.isProjectAdmin(new ProjectImpl(project));
    }

    public boolean isProjectAdmin(Project project) {
        return ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, this.getLoggedInUser());
    }

    public List<Project> getProjectObjects() {
        final ApplicationUser user = this.getLoggedInUser();
        List projects = ComponentAccessor.getProjectManager().getProjectObjects();
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)projects, (Predicate)new Predicate<Project>(){

            public boolean apply(@Nullable Project input) {
                return ComponentAccessor.getPermissionManager().hasPermission(0, user) || ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, input, user);
            }
        }));
    }

    public List<GenericValue> getProjects() {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.getProjectObjects(), (Function)new Function<Project, GenericValue>(){

            public GenericValue apply(@Nullable Project input) {
                return null != input ? input.getGenericValue() : null;
            }
        }));
    }

    public boolean isDefaultAssigneeAssignable(GenericValue project) throws GenericEntityException {
        return this.isDefaultAssigneeAssignable(new ProjectImpl(project));
    }

    public boolean isDefaultAssigneeAssignable(Project project) {
        Long assigneeType = project.getAssigneeType();
        if (assigneeType == null) {
            return true;
        }
        if (2L == assigneeType) {
            return ComponentUtils.isProjectLeadAssignable(project.getGenericValue());
        }
        return true;
    }

    public String abbreviateString(String str, int length) {
        return StringUtils.abbreviate((String)str, (int)length);
    }

    public ApplicationUser getUser(GenericValue project) {
        return this.userManager.getUserByKey(project.getString("lead"));
    }

    public boolean getStringSet(GenericValue gv, String value) {
        return TextUtils.stringSet((String)gv.getString(value));
    }

    public String getPrettyAssigneeType(Long assigneeType) {
        return ProjectAssigneeTypes.getPrettyAssigneeType((Long)assigneeType);
    }

    public String getPrettyAssigneeType(Project project) {
        return this.getPrettyAssigneeType(project.getAssigneeType());
    }

    public boolean isAllowSignUp() {
        return this.userManager.hasPasswordWritableDirectory() && JiraUtils.isPublicMode();
    }
}

