/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project.enterprise;

import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.action.component.SelectComponentAssigneesUtil;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.web.action.project.AbstractProjectAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class SelectComponentAssignees
extends AbstractProjectAction {
    private static final String SECURITY_BREACH = "securitybreach";
    private static final String FIELD_PREFIX = "component_";
    private Long projectId;
    private final SelectComponentAssigneesUtil selectComponentAssigneesUtil;
    private final ProjectComponentManager projectComponentManager;
    private final ProjectManager projectManager;

    public SelectComponentAssignees(ProjectManager projectManager, SelectComponentAssigneesUtil selectComponentAssigneesUtil, ProjectComponentManager projectComponentManager) {
        this.projectManager = projectManager;
        this.selectComponentAssigneesUtil = selectComponentAssigneesUtil;
        this.projectComponentManager = projectComponentManager;
    }

    protected void doValidation() {
        Map<ProjectComponent, Long> components = null;
        try {
            components = this.getUpdateComponentAssigneeTypes();
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (components != null) {
            this.selectComponentAssigneesUtil.setComponentAssigneeTypes(components);
            this.selectComponentAssigneesUtil.setFieldPrefix(SelectComponentAssignees.getFieldPrefix());
            ErrorCollection errors = this.selectComponentAssigneesUtil.validate();
            if (errors != null && errors.hasAnyErrors()) {
                this.addErrorCollection(errors);
            }
        }
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (!this.selectComponentAssigneesUtil.hasPermission(this.getProject(), this.getLoggedInUser())) {
            return SECURITY_BREACH;
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (!this.selectComponentAssigneesUtil.hasPermission(this.getProject(), this.getLoggedInUser())) {
            return SECURITY_BREACH;
        }
        this.selectComponentAssigneesUtil.setComponentAssigneeTypes(this.getUpdateComponentAssigneeTypes());
        this.addErrorCollection(this.selectComponentAssigneesUtil.execute(this.getLoggedInUser()));
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getKey() + "/summary");
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Collection<ProjectComponent> getComponents() {
        try {
            return this.projectComponentManager.findAllForProject(this.getProject().getId());
        }
        catch (GenericEntityException e) {
            return Collections.emptyList();
        }
    }

    public String getComponentFieldName(GenericValue component) {
        return SelectComponentAssignees.getFieldPrefix() + component.getLong("id");
    }

    public long getComponentAssigneeType(GenericValue component) {
        return ComponentUtils.getComponentAssigneeType(component);
    }

    public Map getComponentAssigneeTypes(GenericValue component) {
        return ComponentAssigneeTypes.getAssigneeTypes(component);
    }

    public static String getFieldPrefix() {
        return FIELD_PREFIX;
    }

    public Project getProject() throws GenericEntityException {
        return this.projectManager.getProjectObj(this.getProjectId());
    }

    private Map<ProjectComponent, Long> getUpdateComponentAssigneeTypes() throws EntityNotFoundException {
        HashMap<ProjectComponent, Long> returnedMap = new HashMap<ProjectComponent, Long>();
        Map parameters = ActionContext.getParameters();
        Set keys = parameters.keySet();
        for (Object key1 : keys) {
            String key = (String)key1;
            if (!key.startsWith(SelectComponentAssignees.getFieldPrefix())) continue;
            Long componentId = new Long(key.substring(SelectComponentAssignees.getFieldPrefix().length()));
            ProjectComponent component = this.projectComponentManager.find(componentId);
            returnedMap.put(component, ParameterUtils.getLongParam((Map)parameters, (String)key));
        }
        return returnedMap;
    }

    public String getAvatarUrl() {
        return ActionContext.getRequest().getContextPath() + "/secure/projectavatar?pid=" + this.getProjectId() + "&avatarId=" + this.getAvatarId();
    }
}

