/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;

public class ClearRememberMeCookies
extends JiraWebActionSupport {
    private final RememberMeTokenDao rememberMeTokenDao;

    public ClearRememberMeCookies(RememberMeTokenDao rememberMeTokenDao) {
        this.rememberMeTokenDao = rememberMeTokenDao;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        ApplicationUser current = this.getLoggedInUser();
        if (current == null) {
            return "error";
        }
        return super.doDefault();
    }

    protected void doValidation() {
        try {
            this.getLoggedInUser();
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("rememberme.could.not.find.user"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        ApplicationUser current = this.getLoggedInUser();
        if (current == null) {
            return "error";
        }
        if (this.invalidInput()) {
            return "error";
        }
        this.rememberMeTokenDao.removeAllForUser(current.getName());
        return this.returnComplete();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doSuccess() {
        return "success";
    }
}

