/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.rights.ShareRight;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypePermissionChecker;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

abstract class AbstractSharedEntityDisplayBean {
    final JiraAuthenticationContext authCtx;
    private final SharedEntity sharedEntity;
    private final FavouritesService favouriteService;
    private final GlobalPermissionManager permissionManager;
    private final ShareTypeFactory shareTypeFactory;
    private final UserFormats userFormats;
    private final ShareManager shareManager;
    private final String contextSensitiveId;
    private Boolean isFavourite = null;
    private Collection<SharePermission> sortedPermissions;
    private Collection<SharePermission> allSharePermissions;

    AbstractSharedEntityDisplayBean(JiraAuthenticationContext authCtx, SharedEntity sharedEntity, FavouritesService favouriteService, GlobalPermissionManager permissionManager, ShareTypeFactory shareTypeFactory, UserFormats userFormats, ShareManager shareManager, String contextSensitiveId) {
        this.authCtx = authCtx;
        this.sharedEntity = sharedEntity;
        this.favouriteService = favouriteService;
        this.permissionManager = permissionManager;
        this.shareTypeFactory = shareTypeFactory;
        this.userFormats = userFormats;
        this.shareManager = shareManager;
        this.contextSensitiveId = contextSensitiveId;
    }

    public Long getId() {
        return this.sharedEntity.getId();
    }

    public String getOwnerUserName() {
        ApplicationUser owner = this.sharedEntity.getOwner();
        if (owner != null) {
            return this.userFormats.formatter("userName").formatUserkey(owner.getKey(), this.getContextSensitiveId());
        }
        return null;
    }

    private String getContextSensitiveId() {
        return this.contextSensitiveId;
    }

    public String getOwnerFullName() {
        ApplicationUser owner = this.sharedEntity.getOwner();
        if (owner != null) {
            return this.userFormats.formatter("fullName").formatUserkey(owner.getKey(), this.getContextSensitiveId());
        }
        return null;
    }

    public String getName() {
        return this.sharedEntity.getName();
    }

    public boolean isCurrentOwner() {
        ApplicationUser owner = this.sharedEntity.getOwner();
        return owner != null && owner.equals((Object)this.authCtx.getLoggedInUser());
    }

    public boolean canEdit() {
        return this.shareManager.isSharedWith(this.authCtx.getLoggedInUser(), this.sharedEntity, (ShareRight)ShareRights.VIEW_EDIT);
    }

    public String getDescription() {
        return this.sharedEntity.getDescription();
    }

    public boolean isPrivate() {
        return this.sharedEntity.getPermissions().isPrivate();
    }

    public boolean isFavourite() {
        ApplicationUser user = this.authCtx.getLoggedInUser();
        if (this.isFavourite == null) {
            try {
                this.isFavourite = this.favouriteService.isFavourite(user, this.sharedEntity);
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.isFavourite;
    }

    public Long getFavouriteCount() {
        return this.sharedEntity.getFavouriteCount();
    }

    public long getAlternateFavouriteCount() {
        return this.isFavourite() ? (long)(this.sharedEntity.getFavouriteCount().intValue() - 1) : (long)(this.sharedEntity.getFavouriteCount().intValue() + 1);
    }

    public boolean canShare() {
        return this.permissionManager.hasPermission(GlobalPermissionKey.CREATE_SHARED_OBJECTS, this.authCtx.getLoggedInUser());
    }

    public boolean canEditColumns() {
        return true;
    }

    public Collection<SharePermission> getSharePermissions() {
        if (this.sortedPermissions == null) {
            ArrayList permissions;
            if (this.canEdit()) {
                permissions = new ArrayList(this.sharedEntity.getPermissions().getPermissionSet());
            } else {
                SharedEntity.SharePermissions sharedEntityPermissions = this.sharedEntity.getPermissions();
                permissions = Lists.newArrayListWithCapacity((int)sharedEntityPermissions.size());
                for (SharePermission sharePermission : sharedEntityPermissions) {
                    ShareTypePermissionChecker permissionChecker;
                    ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
                    if (type == null || !(permissionChecker = type.getPermissionsChecker()).hasPermission(this.authCtx.getLoggedInUser(), sharePermission)) continue;
                    permissions.add(sharePermission);
                }
            }
            Collections.sort(permissions, this.shareTypeFactory.getPermissionComparator());
            this.sortedPermissions = permissions;
        }
        return this.sortedPermissions;
    }

    public Collection<SharePermission> getAllSharePermissions() {
        if (this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.authCtx.getLoggedInUser())) {
            if (this.allSharePermissions == null) {
                ArrayList permissions = Lists.newArrayList((Iterable)this.sharedEntity.getPermissions());
                Collections.sort(permissions, this.shareTypeFactory.getPermissionComparator());
                this.allSharePermissions = permissions;
            }
            return this.allSharePermissions;
        }
        return this.getSharePermissions();
    }

    public String getShareView(SharePermission sharePermission) {
        ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
        if (type != null) {
            ShareTypeRenderer shareTypeRenderer = type.getRenderer();
            return shareTypeRenderer.renderPermission(sharePermission, this.authCtx);
        }
        return null;
    }

    public String getSimpleDescription(SharePermission sharePermission) {
        ShareType type = this.shareTypeFactory.getShareType(sharePermission.getType());
        if (type != null) {
            ShareTypeRenderer shareTypeRenderer = type.getRenderer();
            return shareTypeRenderer.getSimpleDescription(sharePermission, this.authCtx);
        }
        return null;
    }
}

