/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.atlassian.jira.sharing.type.ShareTypeRenderer;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class ShareTypeRendererBean {
    private final JiraAuthenticationContext authenticationContext;
    private final ShareTypeRenderer renderer;
    private final ShareType.Name shareTypeName;
    private final ShareTypeRenderer.RenderMode renderMode;
    private final SharedEntity.TypeDescriptor typeDescriptor;
    private final boolean available;

    public ShareTypeRendererBean(ShareType shareType, JiraAuthenticationContext authenticationContext, ShareTypeRenderer.RenderMode renderMode, SharedEntity.TypeDescriptor typeDescriptor) {
        Assertions.notNull((String)"shareType", (Object)shareType);
        Assertions.notNull((String)"authenticationContext", (Object)authenticationContext);
        Assertions.notNull((String)"renderMode", (Object)renderMode);
        Assertions.notNull((String)"typeDescriptor", (Object)typeDescriptor);
        this.typeDescriptor = typeDescriptor;
        this.authenticationContext = authenticationContext;
        this.renderMode = renderMode;
        this.shareTypeName = shareType.getType();
        this.renderer = shareType.getRenderer();
        this.available = shareType.isAvailable();
    }

    public String getShareType() {
        return this.shareTypeName.get();
    }

    public String getShareTypeEditor() {
        return this.renderer.getShareTypeEditor(this.authenticationContext);
    }

    public String getShareTypeSelector() {
        return this.renderer.getShareTypeEditor(this.authenticationContext);
    }

    public boolean isAddButtonNeeded() {
        return this.renderer.isAddButtonNeeded(this.authenticationContext);
    }

    public String getShareTypeLabel() {
        return this.renderer.getShareTypeLabel(this.authenticationContext);
    }

    public boolean isAvailable() {
        return this.available;
    }

    public Map getTranslatedTemplates() {
        return this.renderer.getTranslatedTemplates(this.authenticationContext, this.typeDescriptor, this.renderMode);
    }

    public static Collection<ShareTypeRendererBean> getShareTypeRendererBeans(JiraAuthenticationContext authCtx, ShareTypeFactory shareTypeFactory, ShareType.UsageContextType usageContextType, SharedEntity.TypeDescriptor typeDescriptor) {
        return shareTypeFactory.getAllShareTypes().stream().filter(shareType -> shareType.getValidUsageContextTypes().contains(usageContextType)).map(shareType -> new ShareTypeRendererBean((ShareType)shareType, authCtx, ShareTypeRenderer.RenderMode.EDIT, typeDescriptor)).collect(Collectors.toList());
    }
}

