/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.subtask;

import com.atlassian.jira.bean.SubTask;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.component.SimpleColumnLayoutItem;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractSubTaskColumnLayoutItem
extends SimpleColumnLayoutItem {
    private final VelocityTemplatingEngine velocity;
    private final SubTaskBean subTaskBean;
    private final String subTasksView;
    private final Collection<SubTask> subTasks;

    protected AbstractSubTaskColumnLayoutItem(VelocityTemplatingEngine velocity, SubTaskBean subTaskBean, String subTasksView) {
        this.velocity = velocity;
        this.subTaskBean = subTaskBean;
        this.subTasksView = subTasksView;
        this.subTasks = subTaskBean.getSubTasks(subTasksView);
    }

    @Override
    public String getHtml(Map displayParams, Issue issue) {
        return this.velocity.render(TemplateSources.file((String)this.getTemplate())).applying(this.getContext(issue)).asHtml();
    }

    protected abstract Map<String, Object> getContext(Issue var1);

    protected abstract String getTemplate();

    protected Long getCurrentSubTaskSequence(Issue issue) {
        for (SubTask subTask : this.subTasks) {
            if (!subTask.getSubTask().equals((Object)issue)) continue;
            return subTask.getSequence();
        }
        return new Long(-1L);
    }

    protected Collection<SubTask> getSubTasks() {
        return this.subTasks;
    }
}

