/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.subtask;

import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraWebUtils;
import com.atlassian.jira.web.component.SimpleColumnLayoutItem;
import com.atlassian.jira.web.component.subtask.ActionsAndOperationsColumnLayoutItem;
import com.atlassian.jira.web.component.subtask.SubTaskReorderColumnLayoutItem;
import com.atlassian.jira.web.component.subtask.SubTaskSequenceColumnLayoutItem;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class ColumnLayoutItemFactory {
    private final PermissionManager permissionManager;
    private final VelocityTemplatingEngine templatingEngine;
    private final JiraAuthenticationContext authenticationContext;
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private final I18nHelper.BeanFactory beanFactory;

    public ColumnLayoutItemFactory(PermissionManager permissionManager, VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext authenticationContext, XsrfTokenGenerator xsrfTokenGenerator, I18nHelper.BeanFactory beanFactory) {
        this.permissionManager = permissionManager;
        this.templatingEngine = templatingEngine;
        this.authenticationContext = authenticationContext;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.beanFactory = beanFactory;
    }

    public ColumnLayoutItem getSubTaskReorderColumn(ApplicationUser user, Issue parentIssue, SubTaskBean subTaskBean, String subTaskView) {
        I18nHelper i18n = this.beanFactory.getInstance(user);
        return new SubTaskReorderColumnLayoutItem(this.permissionManager, user, this.templatingEngine, subTaskBean, subTaskView, JiraWebUtils.getHttpRequest().getContextPath(), parentIssue, i18n);
    }

    public ColumnLayoutItem getActionsAndOperationsColumn() {
        return new ActionsAndOperationsColumnLayoutItem(this.templatingEngine, this.authenticationContext, this.xsrfTokenGenerator);
    }

    public ColumnLayoutItem getSubTaskDisplaySequenceColumn(SubTaskBean subTaskBean, String subTaskView) {
        return new SubTaskSequenceColumnLayoutItem(this.templatingEngine, subTaskBean, subTaskView);
    }

    public ColumnLayoutItem getSubTaskSimpleSummaryColumn() {
        return new SimpleColumnLayoutItem(){
            final int displaySequence = 0;
            final String contextPath = JiraWebUtils.getHttpRequest().getContextPath();

            @Override
            public String getHtml(Map displayParams, Issue issue) {
                StringBuilder html = new StringBuilder();
                html.append("<a class='issue-link' data-issue-key='").append(issue.getKey()).append("' href='").append(this.contextPath).append("/browse/").append(issue.getKey()).append("'>").append(TextUtils.htmlEncode((String)issue.getSummary())).append("</a>");
                return html.toString();
            }

            @Override
            protected String getColumnCssClass() {
                return "stsummary";
            }
        };
    }
}

