/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.exception;

import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebExceptionChecker {
    private static final Set<Predicate<Throwable>> IGNORED_EXCEPTIONS = new LinkedHashSet<Predicate<Throwable>>();
    private static final Logger log = LoggerFactory.getLogger(WebExceptionChecker.class);

    public static boolean canBeSafelyIgnored(Throwable throwable) {
        Assertions.notNull((String)"throwable", (Object)throwable);
        for (Predicate<Throwable> predicate : IGNORED_EXCEPTIONS) {
            if (!predicate.evaluate((Object)throwable)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Ignoring this exception", throwable);
            }
            return true;
        }
        return false;
    }

    static {
        IGNORED_EXCEPTIONS.add(new Predicate<Throwable>(){

            public boolean evaluate(Throwable throwable) {
                return "org.apache.catalina.connector.ClientAbortException".equals(throwable.getClass().getName());
            }
        });
        IGNORED_EXCEPTIONS.add(new Predicate<Throwable>(){

            public boolean evaluate(Throwable throwable) {
                String msg;
                if ("java.net.SocketException".equals(throwable.getClass().getName()) && StringUtils.isNotBlank((CharSequence)(msg = throwable.getMessage()))) {
                    return msg.contains("Connection reset") || msg.contains("Broken pipe");
                }
                return false;
            }
        });
    }
}

