/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionInvalidator;
import com.atlassian.seraph.filter.HttpAuthFilter;
import com.atlassian.seraph.filter.LoginFilter;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JiraLoginFilter
extends AbstractHttpFilter {
    private static final String OS_AUTH_TYPE = "os_authType";
    private final Filter seraphLoginFilter;
    private final Filter seraphHttpAuthFilter;

    public JiraLoginFilter() {
        this((Filter)new LoginFilter(), (Filter)new HttpAuthFilter());
    }

    JiraLoginFilter(Filter seraphLoginFilter, Filter seraphHttpAuthFilter) {
        this.seraphLoginFilter = (Filter)Assertions.notNull((String)"seraphLoginFilter", (Object)seraphLoginFilter);
        this.seraphHttpAuthFilter = (Filter)Assertions.notNull((String)"seraphHttpAuthFilter", (Object)seraphHttpAuthFilter);
    }

    protected void doFilter(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.getSessionInvalidator().ifPresent(jiraUserSessionInvalidator -> jiraUserSessionInvalidator.handleSessionInvalidation(servletRequest));
        Filter seraphFilterToRun = this.chooseFilterStrategy((ServletRequest)servletRequest);
        seraphFilterToRun.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse, filterChain);
    }

    private Filter chooseFilterStrategy(ServletRequest servletRequest) {
        if (this.hasOpenSymphonyParameters(servletRequest)) {
            return this.seraphLoginFilter;
        }
        return this.seraphHttpAuthFilter;
    }

    private boolean hasOpenSymphonyParameters(ServletRequest servletRequest) {
        return servletRequest.getParameter("os_username") != null || servletRequest.getParameter(OS_AUTH_TYPE) != null;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.seraphLoginFilter.init(filterConfig);
        this.seraphHttpAuthFilter.init(filterConfig);
    }

    public void destroy() {
        this.seraphLoginFilter.destroy();
        this.seraphHttpAuthFilter.destroy();
    }

    private Optional<JiraUserSessionInvalidator> getSessionInvalidator() {
        return ComponentAccessor.getComponentSafely(JiraUserSessionInvalidator.class);
    }
}

