/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.johnson;

import com.atlassian.jira.web.filters.johnson.JohnsonInterceptor;
import com.atlassian.jira.web.startup.StartupPageSupport;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.filters.AbstractJohnsonFilter;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class JiraJohnsonFilter
extends AbstractJohnsonFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JiraJohnsonFilter.class);
    public static final String JOHNSON_ALREADY_FILTERED = JiraJohnsonFilter.class.getName() + "_already_filtered";

    public static String getServletPathFromRequest(HttpServletRequest request) {
        return JiraJohnsonFilter.getServletPath((HttpServletRequest)request);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getAttribute(JOHNSON_ALREADY_FILTERED) == null) {
            servletRequest.setAttribute(JOHNSON_ALREADY_FILTERED, (Object)Boolean.TRUE);
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            JohnsonEventContainer container = this.getContainerAndRunEventChecks(request);
            JohnsonInterceptor johnsonInterceptor = JohnsonInterceptor.getInstance(container, JiraJohnsonFilter.getServletPath((HttpServletRequest)request), this.config.getSetupConfig(), request, arg_0 -> ((JiraJohnsonFilter)this).ignoreURI(arg_0));
            Optional<JohnsonInterceptor.Reason> intercepted = johnsonInterceptor.intercept();
            if (intercepted.isPresent()) {
                this.redirectByReason(response, request, container, intercepted.get());
                return;
            }
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean redirectByReason(HttpServletResponse response, HttpServletRequest httpServletRequest, JohnsonEventContainer johnsonEventContainer, JohnsonInterceptor.Reason reason) throws IOException {
        switch (reason) {
            case JOHNSON_EVENT: {
                this.handleError(johnsonEventContainer, httpServletRequest, response);
                return true;
            }
            case STARTUP_PAGE: {
                StartupPageSupport.redirectToStartupPage(httpServletRequest, response);
                return true;
            }
            case NOT_SETUP: {
                this.handleNotSetup(httpServletRequest, response);
            }
        }
        return false;
    }

    protected void handleError(JohnsonEventContainer container, HttpServletRequest request, HttpServletResponse response) throws IOException {
        JiraJohnsonFilter.redirect(request, response, "JIRA currently has application level errors.", this.config.getErrorPath());
    }

    protected void handleNotSetup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JiraJohnsonFilter.redirect(request, response, "JIRA has not been configured, yet.", this.config.getSetupPath());
    }

    private static void redirect(HttpServletRequest request, HttpServletResponse response, String message, String targetPath) throws IOException {
        String contextPath = request.getContextPath();
        LOG.debug("{} Redirecting request from '{}' to '{}'", new Object[]{message, JiraJohnsonFilter.getServletPath((HttpServletRequest)request), targetPath});
        response.sendRedirect(contextPath + targetPath);
    }
}

