/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.security.csp;

import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.web.filters.steps.security.csp.Browser;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class DynamicContentSecurityPolicyResponseWrapper
extends HttpServletResponseWrapper {
    private static final String CONTENT_SECURITY_POLICY_SANDBOX_VALUE = "sandbox";
    private final Set<String> sandboxContentTypeExceptionList;
    private final Set<String> sandboxContentDispositionApplyList;
    private final Set<String> sandboxBrowserDifferentiatedPaths;
    private final Map<Browser, String> sandboxBrowserDifferentiatedPostfixes;
    private final boolean featureFlagEnabled;
    private final HttpServletResponse response;
    private final HttpServletRequest request;

    DynamicContentSecurityPolicyResponseWrapper(HttpServletResponse response, HttpServletRequest request, boolean featureFlagEnabled, Set<String> sandboxContentTypeExceptionList, Set<String> sandboxContentDispositionApplyList, Set<String> sandboxBrowserDifferentiatedPaths, Map<Browser, String> sandboxBrowserDifferentiatedPostfixes) {
        super(response);
        this.featureFlagEnabled = featureFlagEnabled;
        this.sandboxContentTypeExceptionList = sandboxContentTypeExceptionList;
        this.sandboxContentDispositionApplyList = sandboxContentDispositionApplyList;
        this.sandboxBrowserDifferentiatedPaths = sandboxBrowserDifferentiatedPaths;
        this.sandboxBrowserDifferentiatedPostfixes = sandboxBrowserDifferentiatedPostfixes;
        this.response = response;
        this.request = request;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        if (this.featureFlagEnabled && (type == null || this.isContentTypeSandboxed(type))) {
            this.setContentSecurityPolicyHeader();
        }
    }

    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        if (this.shouldHeaderBeSandboxed(name, value)) {
            this.setContentSecurityPolicyHeader();
        }
    }

    public void addHeader(String name, String value) {
        super.addHeader(name, value);
        if (this.shouldHeaderBeSandboxed(name, value)) {
            this.setContentSecurityPolicyHeader();
        }
    }

    private boolean shouldHeaderBeSandboxed(String name, String value) {
        return this.featureFlagEnabled && (name.equalsIgnoreCase("Content-Disposition") && this.isContentDispositionSandboxed(value) || name.equalsIgnoreCase("Content-Type") && this.isContentTypeSandboxed(value));
    }

    private void setContentSecurityPolicyHeader() {
        this.response.setHeader("Content-Security-Policy", this.getSandboxClause());
    }

    private String getSandboxClause() {
        Optional<String> sandboxPostfixClause = Optional.empty();
        String servletPath = this.request.getServletPath();
        if (this.sandboxBrowserDifferentiatedPaths.contains(servletPath)) {
            Browser browser = this.getBrowserBasedOnUserAgent();
            sandboxPostfixClause = Optional.ofNullable(this.sandboxBrowserDifferentiatedPostfixes.get((Object)browser));
        }
        return sandboxPostfixClause.map(s -> "sandbox " + s).orElse(CONTENT_SECURITY_POLICY_SANDBOX_VALUE);
    }

    private boolean isContentTypeSandboxed(String type) {
        return Arrays.stream(type.split(";")).noneMatch(this.sandboxContentTypeExceptionList::contains);
    }

    private boolean isContentDispositionSandboxed(String disposition) {
        return Arrays.stream(disposition.split(";")).anyMatch(this.sandboxContentDispositionApplyList::contains);
    }

    private Browser getBrowserBasedOnUserAgent() {
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        UserAgentUtil.UserAgent userAgent = userAgentUtil.getUserAgentInfo(this.request.getHeader("User-Agent"));
        UserAgentUtil.BrowserFamily browserFamily = userAgent.getBrowser().getBrowserFamily();
        UserAgentUtil.OperatingSystem.OperatingSystemFamily operatingSystemFamily = userAgent.getOperatingSystem().getOperatingSystemFamily();
        if (browserFamily.equals((Object)UserAgentUtil.BrowserFamily.FIREFOX)) {
            return Browser.FIREFOX_DESKTOP;
        }
        if (browserFamily.equals((Object)UserAgentUtil.BrowserFamily.CHROME_IOS)) {
            return Browser.CHROME_IOS;
        }
        if (browserFamily.equals((Object)UserAgentUtil.BrowserFamily.CHROME)) {
            if (operatingSystemFamily.equals((Object)UserAgentUtil.OperatingSystem.OperatingSystemFamily.ANDROID)) {
                return Browser.CHROME_ANDROID;
            }
            return Browser.CHROME_DESKTOP;
        }
        if (browserFamily.equals((Object)UserAgentUtil.BrowserFamily.EDGE_LEGACY)) {
            return Browser.EDGE_LEGACY_DESKTOP;
        }
        if (browserFamily.equals((Object)UserAgentUtil.BrowserFamily.ANDROID)) {
            return Browser.ANDROID;
        }
        if (browserFamily.equals((Object)UserAgentUtil.BrowserFamily.SAFARI)) {
            if (operatingSystemFamily.equals((Object)UserAgentUtil.OperatingSystem.OperatingSystemFamily.IPHONE) || operatingSystemFamily.equals((Object)UserAgentUtil.OperatingSystem.OperatingSystemFamily.IPAD)) {
                return Browser.SAFARI_IOS;
            }
            return Browser.SAFARI_DESKTOP;
        }
        return Browser.OTHER;
    }
}

