/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly;

import com.atlassian.jira.ajsmeta.HtmlMetadataManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.web.HttpRequestLocal;
import com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly.BodyAttributesWriter;
import com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly.BodyClassesWriter;
import com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly.CustomHeadContentProvider;
import com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly.ParsedHeadWriter;
import com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly.TitleWriter;
import com.atlassian.jira.web.util.ProductVersionDataBeanProvider;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;

public class PagePartsFactory {
    private final SoyTemplateRendererProvider soyRendererProvider;
    private final ProductVersionDataBeanProvider productVersionDataBeanProvider;
    private final HtmlMetadataManager htmlMetadataManager;
    private final ApplicationProperties applicationProperties;

    public PagePartsFactory(SoyTemplateRendererProvider soyRendererProvider, ProductVersionDataBeanProvider productVersionDataBeanProvider, HtmlMetadataManager htmlMetadataManager, ApplicationProperties applicationProperties) {
        this.soyRendererProvider = soyRendererProvider;
        this.productVersionDataBeanProvider = productVersionDataBeanProvider;
        this.htmlMetadataManager = htmlMetadataManager;
        this.applicationProperties = applicationProperties;
    }

    public PagePartsWriters getPagePartsWriters(HttpServletResponse httpServletResponse) throws IOException {
        return new PagePartsWriters(httpServletResponse);
    }

    public class PagePartsWriters {
        private final PrintWriter responseWriter;
        private final HttpRequestLocal<CustomHeadContentProvider> customHeadContentProviderHttpRequestLocal = new HttpRequestLocal("custom.head.content.provider");

        public PagePartsWriters(HttpServletResponse response) throws IOException {
            this.responseWriter = response.getWriter();
        }

        public BodyAttributesWriter bodyAttributes() {
            return new BodyAttributesWriter(this.responseWriter, PagePartsFactory.this.soyRendererProvider.getRenderer(), PagePartsFactory.this.productVersionDataBeanProvider);
        }

        public BodyClassesWriter bodyClasses() {
            return new BodyClassesWriter(this.responseWriter, PagePartsFactory.this.soyRendererProvider.getRenderer());
        }

        public ParsedHeadWriter parsedHead() {
            return new ParsedHeadWriter(this.getCustomHeadContentProvider(), PagePartsFactory.this.htmlMetadataManager);
        }

        public TitleWriter title() {
            return new TitleWriter(this.responseWriter, PagePartsFactory.this.soyRendererProvider.getRenderer(), PagePartsFactory.this.applicationProperties);
        }

        public CustomHeadContentProvider getCustomHeadContentProvider() {
            if (this.customHeadContentProviderHttpRequestLocal.get() == null) {
                this.customHeadContentProviderHttpRequestLocal.set(new CustomHeadContentProvider(this.responseWriter, PagePartsFactory.this.soyRendererProvider.getRenderer()));
            }
            return this.customHeadContentProviderHttpRequestLocal.get();
        }
    }
}

