/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.session.currentusers;

import com.atlassian.jira.web.session.currentusers.MutableJiraUserSession;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

class JiraUserSessionTrackerDeletionStrategy {
    private final AtomicBoolean deleteStaleSessionsPermit;
    private long nextCheckTime = System.currentTimeMillis();
    private static final long MAX_SESSION_AGE = 14400000L;
    private static final long MIN_TIME_BETWEEN_CHECKS = 30000L;

    JiraUserSessionTrackerDeletionStrategy() {
        this.deleteStaleSessionsPermit = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteStaleSessions(ConcurrentMap<String, MutableJiraUserSession> liveSessionMap) {
        long now = System.currentTimeMillis();
        if (now >= this.nextCheckTime && this.deleteStaleSessionsPermit.compareAndSet(false, true)) {
            try {
                this.cleanupStaleSessions(liveSessionMap);
            }
            finally {
                this.nextCheckTime = now + 30000L;
                this.deleteStaleSessionsPermit.set(false);
            }
        }
    }

    private void cleanupStaleSessions(ConcurrentMap<String, MutableJiraUserSession> liveSessionMap) {
        Iterator it = liveSessionMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            if (!this.sessionHasExpired((MutableJiraUserSession)next.getValue())) continue;
            it.remove();
        }
    }

    private boolean sessionHasExpired(MutableJiraUserSession userSession) {
        if (userSession == null) {
            return false;
        }
        Date lastAccessTime = userSession.getLastAccessTime();
        long sessionAgeMillis = System.currentTimeMillis() - lastAccessTime.getTime();
        return sessionAgeMillis > 14400000L;
    }
}

