/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.tags.i18n;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class MessageTag
extends WebWorkBodyTagSupport
implements ParamTag.UnnamedParametric {
    private static final String I18N_METADATA_OUTPUT_DEFAULT_VALUE = "true";
    private String key;
    private boolean includeMetaData = false;
    private List<Object> arguments = new ArrayList<Object>();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isIncludeMetaData() {
        return this.includeMetaData;
    }

    public void setIncludeMetaData(boolean includeMetaData) {
        this.includeMetaData = includeMetaData;
    }

    public void addArgument(Object argument) {
        this.arguments.add(argument);
    }

    public void addParameter(String name, Object value) {
        this.addArgument(value);
    }

    public void addParameter(Object value) {
        this.addArgument(value);
    }

    public int doStartTag() throws JspException {
        this.arguments.clear();
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        String i18nKey = this.resolveKeyFromValueStack();
        String message = this.getI18nHelper().getText(i18nKey, this.arguments);
        this.write(message, i18nKey);
        return 6;
    }

    private String resolveKeyFromValueStack() {
        String resolvedKey = this.findString(this.key);
        if (resolvedKey != null) {
            return resolvedKey;
        }
        return this.key;
    }

    private void write(String message, String i18nKey) throws JspTagException {
        try {
            if (this.shouldIncludeI18nMetaData()) {
                this.pageContext.getOut().write("<span data-i18nKey=" + i18nKey + ">");
                this.pageContext.getOut().write(message);
                this.pageContext.getOut().write("</span>");
            } else {
                this.pageContext.getOut().write(message);
            }
        }
        catch (IOException ioe) {
            throw new JspTagException((Throwable)ioe);
        }
    }

    private boolean shouldIncludeI18nMetaData() {
        return this.includeMetaData && this.isI18nMetaDataOutputOn();
    }

    private boolean isI18nMetaDataOutputOn() {
        return Boolean.parseBoolean(this.getI18nMetaDataOutputProperty() == null ? I18N_METADATA_OUTPUT_DEFAULT_VALUE : this.getI18nMetaDataOutputProperty());
    }

    private String getI18nMetaDataOutputProperty() {
        return ((ApplicationProperties)ComponentAccessor.getComponentOfType(ApplicationProperties.class)).getDefaultBackedText("jira.i18n.include.meta-data");
    }

    I18nHelper getI18nHelper() {
        return ((JiraAuthenticationContext)ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class)).getI18nHelper();
    }
}

