/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class MetalResourcesManager {
    private final String contextPath;
    private final Writer out;

    public static String getMetalResources(String contextPath) {
        StringWriter sw = new StringWriter();
        MetalResourcesManager.includeMetalResources(sw, contextPath);
        return sw.toString();
    }

    public static void includeMetalResources(Writer out, String contextPath) {
        MetalResourcesManager manager = new MetalResourcesManager(contextPath, out);
        MetalResourcesManager.includeMetalResources(manager);
    }

    static void includeMetalResources(MetalResourcesManager metalResourcesManager) {
        try {
            metalResourcesManager.writeStyle("metal-all.css").writeScript("jquery-min.js").writeScript("metal-all.js");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public MetalResourcesManager(String contextPath, Writer out) {
        this.contextPath = contextPath;
        this.out = out;
    }

    public MetalResourcesManager writeStyle(String filename) throws IOException {
        this.out.write("<link type='text/css' rel='stylesheet' href='" + this.resourcePath(filename) + "' media='all'>");
        return this;
    }

    public MetalResourcesManager writeScript(String filename) throws IOException {
        this.out.write("<script src='" + this.resourcePath(filename) + "'></script>");
        return this;
    }

    private String resourcePath(String filename) {
        return this.contextPath + "/static-assets/" + filename;
    }
}

