/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webwork.parameters;

import com.atlassian.jira.webwork.parameters.AbstractParameterConverter;
import com.atlassian.jira.webwork.parameters.FloatConverter;

public class FloatArrayConverter
extends AbstractParameterConverter {
    private final FloatConverter converter = new FloatConverter();

    @Override
    public Object convertParameter(String[] parameterValues, Class paramType) throws IllegalArgumentException {
        Float[] convertedValues = new Float[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            convertedValues[i] = this.converter.convert(parameterValues[i], paramType.getComponentType());
        }
        if (paramType.getComponentType().isPrimitive()) {
            return this.convertToPrimitive(convertedValues);
        }
        return convertedValues;
    }

    private Object convertToPrimitive(Float[] convertedValues) {
        float[] primtiveArr = new float[convertedValues.length];
        for (int i = 0; i < convertedValues.length; ++i) {
            primtiveArr[i] = convertedValues[i].floatValue();
        }
        return primtiveArr;
    }
}

