/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webwork.parameters;

import com.atlassian.jira.webwork.parameters.AbstractParameterConverter;
import webwork.util.editor.PropertyEditorException;

public class LongConverter
extends AbstractParameterConverter {
    @Override
    public Object convertParameter(String[] parameterValues, Class paramType) throws IllegalArgumentException {
        return this.convert(parameterValues[0], paramType);
    }

    Long convert(String parameterValue, Class paramType) {
        this.checkPrimitiveInput(parameterValue, paramType, "EMPTY_LONG");
        if (!paramType.isPrimitive() && this.isEmpty(parameterValue)) {
            return null;
        }
        return this.convertTo(parameterValue, paramType);
    }

    private Long convertTo(String parameterValue, Class paramType) {
        try {
            return Long.valueOf(parameterValue);
        }
        catch (NumberFormatException e) {
            throw new PropertyEditorException(paramType.isPrimitive() ? "BAD_LONG" : "BAD_LONGOBJ", (Object)parameterValue);
        }
    }
}

